/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2105;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_4770;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record PlaceBlock(PostActionCommonProperties commonProperties, class_4550 block, class_2338 offset, boolean fancyDisplay) implements PostAction
{
    public PlaceBlock(PostActionCommonProperties properties, class_4550 block, class_2338 offset) {
        this(properties, block, offset, properties.icon() == null && BlockPredicateExtensions.isAny(block) && offset.equals((Object)class_2338.field_10980));
    }

    private static void destroyBlock(class_1937 level, class_2338 pos, boolean drop) {
        boolean flag;
        class_2680 legacy;
        class_2680 blockstate = level.method_8320(pos);
        if (blockstate.method_26215()) {
            return;
        }
        class_3610 fluidstate = level.method_8316(pos);
        if (!(blockstate.method_26204() instanceof class_4770)) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)blockstate));
        }
        if (drop) {
            class_2586 blockentity = blockstate.method_31709() ? level.method_8321(pos) : null;
            class_2248.method_9511((class_2680)blockstate, (class_1937)level, (class_2338)pos, (class_2586)blockentity, null, (class_1799)class_1799.field_8037);
        }
        if ((legacy = fluidstate.method_15759()) == blockstate) {
            legacy = class_2246.field_10124.method_9564();
        }
        if (flag = level.method_30092(pos, legacy, 3, 512)) {
            level.method_33596(null, (class_6880)class_5712.field_28165, pos);
        }
    }

    public PostActionType<? extends PlaceBlock> type() {
        return PostActionTypes.PLACE;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        class_2586 blockEntity;
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        class_2338 pos = lootParams.get(LycheeLootContextParams.BLOCK_POS).method_10081((class_2382)this.offset);
        class_1937 level = context.level();
        class_2680 oldState = level.method_8320(pos);
        class_2680 blockState = BlockPredicateExtensions.anyBlockState(this.block);
        if (blockState.method_26215()) {
            PlaceBlock.destroyBlock(level, pos, false);
            return;
        }
        if (recipe instanceof BlockCrushingRecipe && !oldState.method_26215()) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)oldState));
        }
        Set properties = this.block.comp_1733().map(class_4559::comp_1830).stream().flatMap(Collection::stream).map(class_4559.class_4562::comp_1832).collect(Collectors.toSet());
        for (Map.Entry entry : oldState.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            if (properties.contains(property.method_11899())) continue;
            blockState = (class_2680)blockState.method_47968(property, (Comparable)entry.getValue());
        }
        if (oldState.method_26227().method_33659((class_3611)class_3612.field_15910)) {
            blockState = (class_2680)blockState.method_47968((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        if (!level.method_8501(pos, blockState)) {
            return;
        }
        if (this.block.comp_1734().isPresent() && (blockEntity = level.method_8321(pos)) != null && !blockEntity.method_11011()) {
            class_2487 prevTag = blockEntity.method_38244((class_7225.class_7874)level.method_30349());
            class_2487 originalTag = prevTag.method_10553();
            prevTag.method_10543(((class_2105)this.block.comp_1734().get()).comp_1816());
            if (!prevTag.equals((Object)originalTag)) {
                blockEntity.method_58690(prevTag, (class_7225.class_7874)level.method_30349());
                blockEntity.method_5431();
            }
        }
        level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)blockState));
    }

    @Override
    public class_2561 getDisplayName() {
        class_2680 state = BlockPredicateExtensions.anyBlockState(this.block);
        String key = CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.method_10221(PostActionTypes.PLACE));
        if (state.method_26215()) {
            return class_2561.method_43471((String)(key + ".consume"));
        }
        return class_2561.method_43469((String)key, (Object[])new Object[]{state.method_26204().method_9518()});
    }

    @Override
    public List<class_1799> getOutputItems() {
        return BlockPredicateExtensions.matchedItemStacks(this.block);
    }

    @Override
    public List<class_4550> getOutputBlocks() {
        return BlockPredicateExtensions.isAny(this.block) ? List.of() : List.of(this.block);
    }

    @Override
    public boolean hidden() {
        return this.fancyDisplay() || PostAction.super.hidden();
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    public static class Type
    implements PostActionType<PlaceBlock> {
        public static final MapCodec<PlaceBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(PlaceBlock::commonProperties), (App)BlockPredicateExtensions.CODEC.fieldOf("block").forGetter(PlaceBlock::block), (App)LycheeCodecs.OFFSET.forGetter(PlaceBlock::offset)).apply((Applicative)instance, PlaceBlock::new));
        public static final class_9139<class_9129, PlaceBlock> STREAM_CODEC = class_9139.method_56436(PostActionCommonProperties.STREAM_CODEC, PlaceBlock::commonProperties, (class_9139)class_4550.field_49181, PlaceBlock::block, (class_9139)class_2338.field_48404, PlaceBlock::offset, PlaceBlock::new);

        @Override
        public MapCodec<PlaceBlock> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, PlaceBlock> method_56104() {
            return STREAM_CODEC;
        }
    }
}

