/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_4550;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.context.ActionContext;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.CompoundAction;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record RandomSelect(PostActionCommonProperties commonProperties, List<Entry> entries, int totalWeight, int emptyWeight, class_2096.class_2100 rolls, boolean canRepeat, boolean hidden, boolean preventSync) implements CompoundAction,
PostAction
{
    public RandomSelect(PostActionCommonProperties commonProperties, List<Entry> entries, int emptyWeight, class_2096.class_2100 rolls) {
        this(commonProperties, entries, entries.stream().mapToInt(it -> it.weight).sum() + emptyWeight, emptyWeight, rolls, entries.stream().allMatch(it -> it.action().repeatable()), commonProperties.hidden() || entries.stream().allMatch(it -> it.action().hidden()), entries.stream().allMatch(it -> it.action().preventSync()));
        Preconditions.checkArgument((this.totalWeight > 0 ? 1 : 0) != 0, (Object)"Total weight must be positive");
    }

    public PostActionType<RandomSelect> type() {
        return PostActionTypes.RANDOM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        class_5819 randomSource = context.get(LycheeContextKey.RANDOM);
        if ((times *= BoundsExtensions.random(this.rolls, randomSource)) == 0) {
            return;
        }
        ArrayList validActions = Lists.newArrayList();
        int[] validWeights = new int[this.entries.size()];
        int totalWeights = 0;
        for (Entry entry : this.entries) {
            if (entry.action.test(recipe, context, 1) != 1) continue;
            validWeights[validActions.size()] = entry.weight;
            validActions.add(entry.action);
            totalWeights += entry.weight;
        }
        if (validActions.isEmpty()) {
            return;
        }
        totalWeights += this.emptyWeight;
        int[] childTimes = new int[validActions.size()];
        for (int i = 0; i < times; ++i) {
            int index = this.getRandomEntry(randomSource, validWeights, totalWeights);
            if (index < 0) continue;
            int n = index;
            childTimes[n] = childTimes[n] + 1;
        }
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        for (int i = 0; i < validActions.size(); ++i) {
            if (childTimes[i] <= 0) continue;
            actionContext.jobs.offer(new Job((PostAction)validActions.get(i), childTimes[i]));
        }
    }

    private int getRandomEntry(class_5819 random, int[] weights, int totalWeights) {
        int j = random.method_43048(totalWeights);
        for (int i = 0; i < weights.length; ++i) {
            if ((j -= weights[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<class_1799> getOutputItems() {
        return this.entries.stream().map(it -> it.action.getOutputItems()).flatMap(Collection::stream).toList();
    }

    @Override
    public List<class_4550> getOutputBlocks() {
        return this.entries.stream().map(it -> it.action.getOutputBlocks()).flatMap(Collection::stream).toList();
    }

    @Override
    public class_2561 getDisplayName() {
        if (this.entries.size() == 1 && this.emptyWeight == 0) {
            return class_2561.method_43470((String)"%s \u00d7 %s".formatted(this.entries.getFirst().action.getDisplayName().getString(), BoundsExtensions.getPlainDescription(this.rolls).getString()));
        }
        return CommonProxy.getCycledItem(this.entries, this.entries.getFirst(), (int)1000).action.getDisplayName();
    }

    @Override
    public void getUsedPointers(@Nullable ILycheeRecipe<?> recipe, Consumer<JsonPointer> consumer) {
        for (Entry entry : this.entries) {
            entry.action.getUsedPointers(recipe, consumer);
        }
    }

    @Override
    public Stream<PostAction> getChildActions() {
        return this.entries.stream().map(it -> it.action);
    }

    public record Entry(PostAction action, int weight) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PostAction.MAP_CODEC.forGetter(Entry::action), (App)class_5699.field_33442.optionalFieldOf("weight", (Object)1).forGetter(Entry::weight)).apply((Applicative)instance, Entry::new));
        public static final class_9139<class_9129, Entry> STREAM_CODEC = class_9139.method_56435(PostAction.STREAM_CODEC, Entry::action, (class_9139)class_9135.field_48550, Entry::weight, Entry::new);
    }

    public static class Type
    implements PostActionType<RandomSelect> {
        public static final MapCodec<RandomSelect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(RandomSelect::commonProperties), (App)class_5699.method_36973((Codec)KCodecs.compactList(Entry.CODEC)).fieldOf("entries").forGetter(RandomSelect::entries), (App)class_5699.field_33441.optionalFieldOf("empty_weight", (Object)0).forGetter(RandomSelect::emptyWeight), (App)class_2096.class_2100.field_45763.optionalFieldOf("rolls", (Object)BoundsExtensions.ONE).forGetter(RandomSelect::rolls)).apply((Applicative)instance, RandomSelect::new));
        public static final class_9139<class_9129, RandomSelect> STREAM_CODEC = class_9139.method_56905(PostActionCommonProperties.STREAM_CODEC, RandomSelect::commonProperties, (class_9139)Entry.STREAM_CODEC.method_56433(class_9135.method_56363()), RandomSelect::entries, (class_9139)class_9135.field_48550, RandomSelect::emptyWeight, BoundsExtensions.INT_STREAM_CODEC, RandomSelect::rolls, RandomSelect::new);

        @Override
        public MapCodec<RandomSelect> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, RandomSelect> method_56104() {
            return STREAM_CODEC;
        }
    }
}

