/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action.input;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_3218;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Reference;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record DamageItem(PostActionCommonProperties commonProperties, int damage, Reference target) implements PostAction
{
    public PostActionType<DamageItem> type() {
        return PostActionTypes.DAMAGE_ITEM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        class_1297 thisEntity = (class_1297)lootParams.get(class_181.field_1226);
        ItemStackHolderCollection itemStackHolders = context.get(LycheeContextKey.ITEM);
        class_3218 level = (class_3218)context.level();
        class_1309 entity = thisEntity instanceof class_1309 ? (class_1309)thisEntity : null;
        for (Integer index : indexes) {
            ((ExtendedItemStackHolder)itemStackHolders.get(index)).setConsumption(0);
            class_1799 itemStack = (class_1799)itemStackHolders.split(index, 1).get();
            if (entity != null && entity.method_6047() == itemStack) {
                itemStack.method_7970(this.damage, entity, class_1304.field_6173);
                continue;
            }
            if (entity != null && entity.method_6079() == itemStack) {
                itemStack.method_7970(this.damage, entity, class_1304.field_6171);
                continue;
            }
            CommonProxy.hurtAndBreak(itemStack, this.damage, level, entity);
        }
    }

    @Override
    public boolean hidden() {
        return true;
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe) {
        Preconditions.checkArgument((!recipe.getItemIndexes(this.target).isEmpty() ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    @Override
    public class_1799 transformRemainder(class_1799 itemStack, @Nullable ILycheeRecipe<?> recipe) {
        if (itemStack.method_7963()) {
            class_1799 copy = itemStack.method_7972();
            copy.method_7974(copy.method_7919() + this.damage);
            return copy;
        }
        return class_1799.field_8037;
    }

    public static class Type
    implements PostActionType<DamageItem> {
        public static final MapCodec<DamageItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(DamageItem::commonProperties), (App)Codec.INT.optionalFieldOf("damage", (Object)1).forGetter(DamageItem::damage), (App)Reference.CODEC.optionalFieldOf("target", (Object)Reference.DEFAULT).forGetter(DamageItem::target)).apply((Applicative)instance, DamageItem::new));
        public static final class_9139<class_9129, DamageItem> STREAM_CODEC = class_9139.method_56436(PostActionCommonProperties.STREAM_CODEC, DamageItem::commonProperties, (class_9139)class_9135.field_48550, DamageItem::damage, Reference.STREAM_CODEC, DamageItem::target, DamageItem::new);

        @Override
        public MapCodec<DamageItem> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, DamageItem> method_56104() {
            return STREAM_CODEC;
        }
    }
}

