/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action.input;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Reference;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record SetItem(PostActionCommonProperties commonProperties, class_1799 itemStack, Reference target) implements PostAction
{
    public PostActionType<SetItem> type() {
        return PostActionTypes.SET_ITEM;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        class_5455 registryAccess = context.level().method_30349();
        for (Integer index : indexes) {
            class_2487 tag = (class_2487)context.method_59984(index).method_57358((class_7225.class_7874)registryAccess);
            class_1799 stack = this.getPath().isEmpty() ? this.itemStack.method_7972() : class_1799.method_57359((class_7225.class_7874)registryAccess, (class_2487)CommonProxy.jsonToTag(new JsonPointer(this.getPath().get()).find(context.get(LycheeContextKey.JSON))));
            context.setItem(index, stack);
            if (!stack.method_7960()) {
                ((class_2487)context.method_59984(index).method_57375((class_7225.class_7874)registryAccess)).method_10543(tag);
            }
            ((ExtendedItemStackHolder)context.get(LycheeContextKey.ITEM).get(index)).setConsumption(0);
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return this.itemStack.method_7964();
    }

    @Override
    public List<class_1799> getOutputItems() {
        return List.of(this.itemStack);
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe) {
        Preconditions.checkArgument((!recipe.getItemIndexes(this.target).isEmpty() ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    @Override
    public class_1799 transformRemainder(class_1799 itemStack, @Nullable ILycheeRecipe<?> recipe) {
        return this.itemStack();
    }

    public static class Type
    implements PostActionType<SetItem> {
        public static final MapCodec<SetItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(SetItem::commonProperties), (App)LycheeCodecs.ITEM_STACK_MAP_CODEC.forGetter(SetItem::itemStack), (App)Reference.CODEC.optionalFieldOf("target", (Object)Reference.DEFAULT).forGetter(SetItem::target)).apply((Applicative)instance, SetItem::new));
        public static final class_9139<class_9129, SetItem> STREAM_CODEC = class_9139.method_56436(PostActionCommonProperties.STREAM_CODEC, SetItem::commonProperties, (class_9139)class_1799.field_49268, SetItem::itemStack, Reference.STREAM_CODEC, SetItem::target, SetItem::new);

        @Override
        public MapCodec<SetItem> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, SetItem> method_56104() {
            return STREAM_CODEC;
        }
    }
}

