/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_4770;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;
import snownee.kiwi.util.Color;
import snownee.lychee.client.gui.FluidRenderer;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.UIRenderHelper;
import snownee.lychee.util.VecHelper;

public class GuiGameElement {
    public static GuiRenderBuilder of(class_1799 stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(class_1935 itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(class_2680 blockState) {
        if (blockState.method_26217() != class_2464.field_11458 && blockState.method_26227().method_15769()) {
            return new GuiBlockStateRenderBuilder(blockState, GuiGameElement.of((class_1935)blockState.method_26204()));
        }
        if (blockState.method_26204() instanceof class_2510) {
            blockState = (class_2680)blockState.method_11657((class_2769)class_2510.field_11571, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2510.field_11571)).method_10153());
        }
        return new GuiBlockStateRenderBuilder(blockState);
    }

    public static GuiRenderBuilder of(class_3611 fluid) {
        return new GuiBlockStateRenderBuilder((class_2680)fluid.method_15785().method_15759().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(0)));
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private final class_1799 stack;

        public GuiItemRenderBuilder(class_1799 stack) {
            this.stack = stack;
            this.scale = 10.0;
        }

        public GuiItemRenderBuilder(class_1935 provider) {
            this(provider.method_8389().method_7854());
        }

        @Override
        public void render(class_332 graphics) {
            class_4587 matrixStack = graphics.method_51448();
            this.prepareMatrix(matrixStack);
            this.transformMatrix(matrixStack);
            GuiItemRenderBuilder.renderItemIntoGUI(matrixStack, this.stack, this.customLighting == null);
            this.cleanUpMatrix(matrixStack);
        }

        @Override
        protected void transformMatrix(class_4587 matrixStack) {
            matrixStack.method_46416(this.x(), this.y(), this.z());
            matrixStack.method_22904(this.xLocal * this.scale, this.yLocal * this.scale, this.zLocal * this.scale);
            UIRenderHelper.flipForGuiRender(matrixStack);
        }

        public static void renderItemIntoGUI(class_4587 matrixStack, class_1799 stack, boolean useDefaultLighting) {
            boolean flatLighting;
            class_918 renderer = class_310.method_1551().method_1480();
            class_1087 bakedModel = renderer.method_4019(stack, null, null, 0);
            class_310.method_1551().method_1531().method_4619(class_1723.field_21668).method_4527(false, false);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.method_22903();
            matrixStack.method_46416(0.0f, 0.0f, 100.0f);
            matrixStack.method_46416(8.0f, -8.0f, 0.0f);
            matrixStack.method_22905(16.0f, 16.0f, 16.0f);
            class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
            boolean bl = flatLighting = !bakedModel.method_24304();
            if (useDefaultLighting && flatLighting) {
                class_308.method_24210();
            }
            renderer.method_23179(stack, class_811.field_4317, false, matrixStack, (class_4597)buffer, 0xF000F0, class_4608.field_21444, bakedModel);
            RenderSystem.disableDepthTest();
            buffer.method_22993();
            RenderSystem.enableDepthTest();
            if (useDefaultLighting && flatLighting) {
                class_308.method_24211();
            }
            matrixStack.method_22909();
        }

        @Override
        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            return this;
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        @Nullable
        private final GuiRenderBuilder override;

        public GuiBlockStateRenderBuilder(class_2680 blockState) {
            this(blockState, null);
        }

        public GuiBlockStateRenderBuilder(class_2680 blockState, @Nullable GuiRenderBuilder override) {
            super(class_310.method_1551().method_1541().method_3349(blockState), blockState);
            this.override = override;
        }

        @Override
        public void render(class_332 graphics) {
            if (this.override != null) {
                ((RenderElement)this.override.atLocal(this.xLocal, this.yLocal, this.zLocal).at((Vector2fc)this.position)).offset(-3.0f, -3.0f).render(graphics);
            }
            super.render(graphics);
        }

        @Override
        protected void renderModel(class_776 blockRenderer, class_4597.class_4598 buffer, class_4587 ms) {
            if (this.blockState.method_26204() instanceof class_4770) {
                class_308.method_24210();
                blockRenderer.method_3353(this.blockState, ms, (class_4597)buffer, 0xF000F0, class_4608.field_21444);
                buffer.method_22993();
                class_308.method_24211();
                return;
            }
            super.renderModel(blockRenderer, buffer, ms);
            if (this.blockState.method_26227().method_15769()) {
                return;
            }
            float min = 0.001f;
            float max = 0.999f;
            FluidRenderer.renderFluidBox(this.blockState.method_26227(), min, min, min, max, max * 0.8888889f, max, (class_4597)buffer, ms, 0xF000F0, false);
            buffer.method_22993();
        }
    }

    public static abstract class GuiRenderBuilder
    extends RenderElement {
        protected double xLocal;
        protected double yLocal;
        protected double zLocal;
        protected double xRot;
        protected double yRot;
        protected double zRot;
        protected double scale = 1.0;
        protected int color = 0xFFFFFF;
        protected class_243 rotationOffset = class_243.field_1353;
        protected ILightingSettings customLighting = null;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.xLocal = x;
            this.yLocal = y;
            this.zLocal = z;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((class_2382)class_2338.field_10980));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(class_243 offset) {
            this.rotationOffset = offset;
            return this;
        }

        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            this.customLighting = lighting;
            return this;
        }

        protected void prepareMatrix(class_4587 matrixStack) {
            matrixStack.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            this.prepareLighting(matrixStack);
        }

        protected void transformMatrix(class_4587 matrixStack) {
            float scale = (float)this.scale;
            matrixStack.method_46416(this.x(), this.y() + scale, this.z());
            matrixStack.method_22905(scale, scale, scale);
            matrixStack.method_22904(this.xLocal, this.yLocal, this.zLocal);
            UIRenderHelper.flipForGuiRender(matrixStack);
            matrixStack.method_22904(this.rotationOffset.field_1352, this.rotationOffset.field_1351, this.rotationOffset.field_1350);
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.zRot));
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees((float)this.xRot));
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees((float)this.yRot));
            matrixStack.method_22904(-this.rotationOffset.field_1352, -this.rotationOffset.field_1351, -this.rotationOffset.field_1350);
        }

        protected void cleanUpMatrix(class_4587 matrixStack) {
            matrixStack.method_22909();
            this.cleanUpLighting(matrixStack);
        }

        protected void prepareLighting(class_4587 matrixStack) {
            if (this.customLighting != null) {
                this.customLighting.applyLighting();
            } else {
                class_308.method_24211();
            }
        }

        protected void cleanUpLighting(class_4587 matrixStack) {
            if (this.customLighting != null) {
                class_308.method_24211();
            }
        }
    }

    private static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected class_1087 blockModel;
        protected class_2680 blockState;

        public GuiBlockModelRenderBuilder(class_1087 bakedModel, @Nullable class_2680 blockState) {
            this.blockState = blockState == null ? class_2246.field_10124.method_9564() : blockState;
            this.blockModel = bakedModel;
            this.withRotationOffset(VecHelper.getCenterOf((class_2382)class_2338.field_10980));
        }

        @Override
        public void render(class_332 graphics) {
            class_4587 matrixStack = graphics.method_51448();
            this.prepareMatrix(matrixStack);
            class_310 mc = class_310.method_1551();
            class_776 blockRenderer = mc.method_1541();
            class_4597.class_4598 buffer = mc.method_22940().method_23000();
            this.transformMatrix(matrixStack);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            this.renderModel(blockRenderer, buffer, matrixStack);
            this.cleanUpMatrix(matrixStack);
        }

        protected void renderModel(class_776 blockRenderer, class_4597.class_4598 buffer, class_4587 ms) {
            class_310 mc = class_310.method_1551();
            int color = mc.method_1505().method_1697(this.blockState, (class_1920)mc.field_1687, mc.field_1719 != null ? mc.field_1719.method_24515() : null, 0);
            Color rgb = new Color(color == -1 ? this.color : color);
            blockRenderer.method_3350().method_3367(ms.method_23760(), buffer.getBuffer(this.blockState.method_26204() == class_2246.field_10124 ? class_4722.method_24076() : class_4696.method_23683((class_2680)this.blockState, (boolean)true)), this.blockState, this.blockModel, rgb.getRedAsFloat(), rgb.getGreenAsFloat(), rgb.getBlueAsFloat(), 0xF000F0, class_4608.field_21444);
            buffer.method_22993();
        }
    }
}

