/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3f;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.client.gui.WrapperRenderElement;
import snownee.lychee.util.VectorExtensions;
import snownee.lychee.util.ui.InputAction;

public class InteractiveRenderElement
extends RenderElement
implements WrapperRenderElement,
class_364 {
    @Nullable
    private final Function<InteractiveRenderElement, ScreenElement> renderable;
    @Nullable
    private @Nullable Supplier<@Nullable List<class_2561>> onTooltip;
    @Nullable
    private BiPredicate<InputAction, InteractiveRenderElement> onInput;
    private boolean focused;
    private boolean withScissors;
    private boolean hovered;

    public InteractiveRenderElement(Function<InteractiveRenderElement, ScreenElement> renderable) {
        this.renderable = renderable;
    }

    public static InteractiveRenderElement create(ScreenElement element) {
        if (element instanceof InteractiveRenderElement) {
            InteractiveRenderElement interactiveElement = (InteractiveRenderElement)element;
            return interactiveElement;
        }
        InteractiveRenderElement interactiveElement = new InteractiveRenderElement(ignored -> element);
        if (element instanceof RenderElement) {
            RenderElement renderElement = (RenderElement)element;
            ((RenderElement)interactiveElement.at((Vector2fc)renderElement.position)).withSize((Vector2ic)renderElement.size);
            renderElement.at(VectorExtensions.ZERO3F);
        }
        return interactiveElement;
    }

    public InteractiveRenderElement() {
        this.renderable = null;
    }

    public static void produceClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public boolean method_25370() {
        return this.focused;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    @Override
    public void render(class_332 graphics) {
        if (this.renderable == null) {
            return;
        }
        boolean withScissors = this.withScissors;
        if (withScissors) {
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            Vector3f topLeft = matrix.transformPosition(new Vector3f());
            Vector3f bottomRight = matrix.transformPosition(new Vector3f((float)this.size.x(), (float)this.size.y(), 0.0f));
            graphics.method_44379((int)topLeft.x(), (int)topLeft.y(), (int)bottomRight.x(), (int)bottomRight.y());
        }
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(this.x(), this.y(), this.z());
        this.renderable.apply(this).render(graphics);
        graphics.method_51448().method_22909();
        if (withScissors) {
            graphics.method_44380();
        }
    }

    public InteractiveRenderElement onTooltip(@Nullable @Nullable Supplier<@Nullable List<class_2561>> onTooltip) {
        this.onTooltip = onTooltip;
        return this;
    }

    public InteractiveRenderElement onInput(@Nullable @Nullable BiPredicate<InputAction, @Nullable InteractiveRenderElement> onInput) {
        this.onInput = onInput;
        return this;
    }

    public InteractiveRenderElement withScissors(boolean withScissors) {
        this.withScissors = withScissors;
        return this;
    }

    @Nullable
    public List<class_2561> getTooltip() {
        if (this.onTooltip == null) {
            return null;
        }
        return this.onTooltip.get();
    }

    @Nullable
    public @Nullable BiPredicate<InputAction, @Nullable InteractiveRenderElement> getOnInput() {
        return this.onInput;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.containsMouse(mouseX, mouseY);
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.onInput != null && this.hovered && this.onInput.test(InputAction.mousePressed(button, mouseX, mouseY), this)) {
            InteractiveRenderElement.produceClickSound();
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.onInput != null && this.onInput.test(InputAction.keyPressed(keyCode, scanCode, modifiers), this);
    }

    @Override
    @Nullable
    public ScreenElement getWrappedElement() {
        return this.renderable == null ? null : this.renderable.apply(this);
    }

    public void updateHoverState(double mouseX, double mouseY) {
        this.hovered = this.method_25405(mouseX, mouseY);
    }
}

