/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import snownee.kiwi.util.Color;

public class UIRenderHelper {
    public static CustomRenderTarget framebuffer;

    public static void init() {
        RenderSystem.recordRenderCall(() -> {
            class_1041 mainWindow = class_310.method_1551().method_22683();
            framebuffer = CustomRenderTarget.create(mainWindow);
        });
    }

    public static void updateWindowSize(class_1041 mainWindow) {
        if (framebuffer != null) {
            framebuffer.method_1234(mainWindow.method_4489(), mainWindow.method_4506(), class_310.field_1703);
        }
    }

    public static void drawFramebuffer(float alpha) {
        framebuffer.renderWithAlpha(alpha);
    }

    public static void swapAndBlitColor(class_276 src, class_276 dst) {
        GlStateManager._glBindFramebuffer((int)36008, (int)src.field_1476);
        GlStateManager._glBindFramebuffer((int)36009, (int)dst.field_1476);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)src.field_1480, (int)src.field_1477, (int)0, (int)0, (int)dst.field_1480, (int)dst.field_1477, (int)16384, (int)9729);
        GlStateManager._glBindFramebuffer((int)36160, (int)dst.field_1476);
    }

    public static void drawColoredTexture(class_332 graphics, Color c, int x, int y, int tex_left, int tex_top, int width, int height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, y, 0, tex_left, tex_top, width, height, 256, 256);
    }

    public static void drawColoredTexture(class_332 graphics, Color c, int x, int y, int z, float tex_left, float tex_top, int width, int height, int sheet_width, int sheet_height) {
        UIRenderHelper.drawColoredTexture(graphics, c, x, x + width, y, y + height, z, width, height, tex_left, tex_top, sheet_width, sheet_height);
    }

    private static void drawColoredTexture(class_332 graphics, Color c, int left, int right, int top, int bot, int z, int tex_width, int tex_height, float tex_left, float tex_top, int sheet_width, int sheet_height) {
        UIRenderHelper.drawTexturedQuad(graphics.method_51448().method_23760().method_23761(), c, left, right, top, bot, z, (tex_left + 0.0f) / (float)sheet_width, (tex_left + (float)tex_width) / (float)sheet_width, (tex_top + 0.0f) / (float)sheet_height, (tex_top + (float)tex_height) / (float)sheet_height);
    }

    private static void drawTexturedQuad(Matrix4f m, Color c, int left, int right, int top, int bot, int z, float u1, float u2, float v1, float v2) {
        class_289 tesselator = class_289.method_1348();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34543);
        class_287 bufferbuilder = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22918(m, (float)left, (float)bot, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u1, v2);
        bufferbuilder.method_22918(m, (float)right, (float)bot, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u2, v2);
        bufferbuilder.method_22918(m, (float)right, (float)top, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u2, v1);
        bufferbuilder.method_22918(m, (float)left, (float)top, (float)z).method_1336(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).method_22913(u1, v1);
        tesselator.method_60828();
        RenderSystem.disableBlend();
    }

    public static void flipForGuiRender(class_4587 poseStack) {
        poseStack.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
    }

    public static class CustomRenderTarget
    extends class_276 {
        public CustomRenderTarget(boolean useDepth) {
            super(useDepth);
        }

        public static CustomRenderTarget create(class_1041 mainWindow) {
            CustomRenderTarget framebuffer = new CustomRenderTarget(true);
            framebuffer.method_1234(mainWindow.method_4489(), mainWindow.method_4506(), class_310.field_1703);
            framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            return framebuffer;
        }

        public void renderWithAlpha(float alpha) {
            class_1041 window = class_310.method_1551().method_22683();
            float vx = window.method_4486();
            float vy = window.method_4502();
            float tx = (float)this.field_1480 / (float)this.field_1482;
            float ty = (float)this.field_1477 / (float)this.field_1481;
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(() -> class_310.method_1551().field_1773.field_29403);
            RenderSystem.getShader().method_34583("DiffuseSampler", (Object)this.field_1475);
            this.method_35610();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            bufferbuilder.method_22912(0.0f, vy, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(0.0f, 0.0f);
            bufferbuilder.method_22912(vx, vy, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx, 0.0f);
            bufferbuilder.method_22912(vx, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(tx, ty);
            bufferbuilder.method_22912(0.0f, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(0.0f, ty);
            tessellator.method_60828();
            this.method_1242();
        }
    }
}

