/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4550;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_8786;
import org.joml.Quaternionf;
import snownee.lychee.client.gui.CustomLightingSettings;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.compat.recipeviewer.IngredientInfo;
import snownee.lychee.compat.recipeviewer.IngredientType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.ActionRenderer;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.render.CachedRenderingEntity;

public final class RVs {
    public static final CachedRenderingEntity<class_1541> TNT = CachedRenderingEntity.ofFactory(arg_0 -> ((class_1299)class_1299.field_6063).method_5883(arg_0));
    public static final CachedRenderingEntity<class_1538> LIGHTNING_BOLT = CachedRenderingEntity.ofFactory(arg_0 -> ((class_1299)class_1299.field_6112).method_5883(arg_0));
    public static ILightingSettings BLOCK_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-45.0f, -45.0f).secondLightRotation(15.0f, -60.0f).build();
    public static ILightingSettings SIDE_ICON_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-30.0f, -60.0f).secondLightRotation(30.0f, -60.0f).build();
    public static ILightingSettings ENTITY_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-120.0f, 20.0f).secondLightRotation(200.0f, 45.0f).build();

    public static List<IngredientInfo> generateShapelessInputs(ILycheeRecipe<LycheeContext> recipe) {
        List<IngredientInfo> ingredients;
        try {
            ingredients = recipe.sizedIngredients().stream().map(IngredientInfo::new).toList();
        }
        catch (Exception e) {
            ingredients = recipe.method_8117().stream().map(IngredientInfo::new).toList();
        }
        for (PostAction action : recipe.postActions()) {
            ActionRenderer.of(action).loadCatalystsInfo(action, recipe, ingredients);
        }
        RVs.addIngredientTips(recipe, ingredients);
        return ingredients;
    }

    public static void addIngredientTips(ILycheeRecipe<LycheeContext> recipe, List<IngredientInfo> ingredients) {
        for (IngredientInfo ingredient : ingredients) {
            IngredientType type = CommonProxy.getIngredientType(ingredient.ingredient);
            if (type == IngredientType.NORMAL) continue;
            ingredient.addTooltip((class_2561)class_2561.method_43471((String)("tip.lychee.ingredient." + type.name().toLowerCase(Locale.ROOT))));
        }
    }

    public static class_5250 makeTitle(class_2960 id) {
        int i;
        String key = id.method_42093("recipeType");
        if ("/minecraft/default".equals(key.substring(i = key.indexOf(47)))) {
            key = key.substring(0, i);
        }
        return class_2561.method_43471((String)key);
    }

    public static List<class_2561> getRecipeTooltip(ILycheeRecipe<?> recipe) {
        ArrayList list = Lists.newArrayList();
        if (recipe.comment().map(it -> !Strings.isNullOrEmpty((String)it)).orElse(false).booleanValue()) {
            String comment = recipe.comment().orElseThrow();
            if (class_1074.method_4663((String)comment)) {
                comment = class_1074.method_4662((String)comment, (Object[])new Object[0]);
            }
            Splitter.on((char)'\n').splitToStream((CharSequence)comment).map(class_2561::method_43470).forEach(list::add);
        }
        class_310 mc = class_310.method_1551();
        recipe.conditions().appendToTooltips(list, (class_1937)mc.field_1687, (class_1657)mc.field_1724, 0);
        return list;
    }

    public static <T extends BlockKeyableRecipe> Pair<class_2680, Integer> getMostUsedBlock(Collection<? extends class_8786<? extends T>> recipes) {
        Object2IntOpenHashMap blockStateCount = new Object2IntOpenHashMap();
        HashMap blockPredicateMap = Maps.newHashMap();
        for (class_8786<T> class_87862 : recipes) {
            BlockKeyableRecipe recipe = (BlockKeyableRecipe)class_87862.comp_1933();
            for (class_2248 block : BlockPredicateExtensions.matchedBlocks(recipe.blockPredicate())) {
                if (block.method_9564().method_26215()) continue;
                blockStateCount.mergeInt((Object)block, 1, Integer::sum);
                blockPredicateMap.putIfAbsent(block, recipe.blockPredicate());
            }
        }
        if (blockStateCount.isEmpty()) {
            return Pair.of((Object)class_2246.field_10124.method_9564(), (Object)0);
        }
        return blockStateCount.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map($ -> Pair.of((Object)BlockPredicateExtensions.anyBlockState((class_4550)blockPredicateMap.get($.getKey())), (Object)$.getIntValue())).orElseGet(() -> Pair.of((Object)class_2246.field_10124.method_9564(), (Object)0));
    }

    public static void renderTnt(class_332 graphics) {
        class_1541 tnt = TNT.getEntity();
        int fuse = 80 - tnt.field_6012 % 80;
        if (fuse >= 40) {
            return;
        }
        TNT.earlySetLevel();
        tnt.method_6967(fuse);
        float toRad = (float)Math.PI / 180;
        Quaternionf quaternion = new Quaternionf().rotateXYZ(200.0f * toRad, -20.0f * toRad, 0.0f);
        ENTITY_LIGHTING.applyLighting();
        TNT.render(graphics.method_51448(), quaternion);
    }

    public static void renderLightning(class_332 graphics, float x, float y) {
        class_1538 entity = LIGHTNING_BOLT.getEntity();
        int time = entity.field_6012 % 80;
        if (time > 7) {
            return;
        }
        float toRad = (float)Math.PI / 180;
        Quaternionf quaternion = new Quaternionf().rotateXYZ(200.0f * toRad, -20.0f * toRad, 0.0f);
        if (time % 3 == 0) {
            entity.field_7186 = entity.field_6012;
        }
        ENTITY_LIGHTING.applyLighting();
        LIGHTNING_BOLT.setScale(2.0f);
        LIGHTNING_BOLT.getTranslation().set(x, y, 20.0f);
        LIGHTNING_BOLT.render(graphics.method_51448(), quaternion);
    }

    public static class_2960 composeCategoryIdentifier(class_2960 categoryId, class_2960 group) {
        return class_2960.method_60655((String)categoryId.method_12836(), (String)"%s/%s/%s".formatted(categoryId.method_12832(), group.method_12836(), group.method_12832()));
    }

    public static class_2680 getIconBlock(Collection<? extends class_8786<? extends BlockKeyableRecipe>> recipes) {
        class_634 con = class_310.method_1551().method_1562();
        if (con == null) {
            return class_2246.field_10124.method_9564();
        }
        return (class_2680)RVs.getMostUsedBlock(recipes).getFirst();
    }
}

