/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.KUtil;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.util.ui.CategoryMetadata;
import snownee.lychee.util.ui.CategoryModifier;
import snownee.lychee.util.ui.InputAction;

public abstract class RvHelper {
    private List<class_8786<CategoryMetadata>> metadataList = List.of();
    private List<class_8786<CategoryModifier>> modifierList = List.of();

    public void init() {
        Comparator<class_8786> comparator = Comparator.comparing(class_8786::comp_1933);
        this.metadataList = ImmutableList.sortedCopyOf(comparator, (Iterable)KUtil.getRecipes(RecipeTypes.CATEGORY_METADATA));
        this.modifierList = ImmutableList.sortedCopyOf(comparator, (Iterable)KUtil.getRecipes(RecipeTypes.CATEGORY_MODIFIER));
    }

    public class_8786<CategoryMetadata> getMetadata(RvCategoryInstance<?> category) {
        String id = category.id().toString();
        for (class_8786<CategoryMetadata> metadata : this.metadataList) {
            if (!((CategoryMetadata)metadata.comp_1933()).category().test(id)) continue;
            return metadata;
        }
        return CategoryMetadata.EMPTY;
    }

    public List<class_8786<CategoryModifier>> getModifiers(RvCategoryInstance<?> category) {
        String id = category.id().toString();
        ArrayList list = Lists.newArrayList();
        for (class_8786<CategoryModifier> modifier : this.modifierList) {
            if (!((CategoryModifier)modifier.comp_1933()).category().test(id)) continue;
            list.add(modifier);
        }
        return ImmutableList.copyOf((Collection)list);
    }

    public abstract boolean doAction(class_1799 var1, InputAction.Direct var2);

    public boolean doAction(class_2248 block, InputAction.Direct action) {
        return this.doAction(block.method_8389().method_7854(), action);
    }

    public boolean doAction(class_2680 blockState, InputAction.Direct action) {
        if (blockState.method_27852(class_2246.field_10105) || blockState.method_27852(class_2246.field_10414)) {
            blockState = class_2246.field_10535.method_9564();
        }
        if (blockState.method_26204() instanceof class_2404) {
            return this.doAction(blockState.method_26227(), action);
        }
        return this.doAction(blockState.method_26204(), action);
    }

    public abstract boolean doAction(class_3611 var1, InputAction.Direct var2);

    public boolean doAction(class_3610 fluidState, InputAction.Direct action) {
        return this.doAction(fluidState.method_15772(), action);
    }

    private Optional<InputAction.Direct> toDirectAction(InputAction action, @Nullable InteractiveRenderElement element) {
        if (!action.isMouseOver(element)) {
            return Optional.empty();
        }
        return this.toDirectAction(action);
    }

    public abstract Optional<InputAction.Direct> toDirectAction(InputAction var1);

    public BiPredicate<InputAction, InteractiveRenderElement> inputOnBlock(Supplier<class_2680> blockStateSupplier) {
        return (action, element) -> this.toDirectAction((InputAction)action, (InteractiveRenderElement)element).map(arg_0 -> this.lambda$inputOnBlock$0((Supplier)blockStateSupplier, arg_0)).orElse(false);
    }

    public abstract boolean appendModName();

    private /* synthetic */ Boolean lambda$inputOnBlock$0(Supplier blockStateSupplier, InputAction.Direct direct) {
        return this.doAction((class_2680)blockStateSupplier.get(), direct);
    }
}

