/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.BlockCrushingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.BlockExplodingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.BlockInteractingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.DripstoneRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.ItemBurningRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.ItemExplodingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.ItemInsideRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.LightningChannelingRecipeCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstanceProviders;
import snownee.lychee.compat.recipeviewer.element.SideBlockIcon;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class RvPlugin<Helper extends RvHelper> {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final Map<class_2960, RvCategory<?>> categoryTypes = Maps.newHashMap();
    private ImmutableMap<class_2960, RvCategoryInstance<?>> categories = ImmutableMap.of();
    private final String name = STACK_WALKER.getCallerClass().getSimpleName();
    private final Helper rvHelper;

    public RvPlugin(Helper rvHelper) {
        this.rvHelper = rvHelper;
    }

    public Helper helper() {
        return this.rvHelper;
    }

    public void init() {
        this.categoryTypes.clear();
        ((RvHelper)this.rvHelper).init();
        HashMap categories = Maps.newHashMap();
        this.register(RecipeTypes.BLANK, new RvCategory(), it -> {
            it.iconProvider = category -> RenderElement.empty();
        });
        this.register(RecipeTypes.BLOCK_CRUSHING, new BlockCrushingRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> BlockCrushingRecipeCategory.icon(GuiGameElement.of((class_1935)class_1802.field_8782));
            it.setSimpleWorkstationProvider(category -> category.recipes().stream().map($ -> ((BlockCrushingRecipe)$.comp_1933()).blockPredicate()).filter($ -> !BlockPredicateExtensions.isAny($)).distinct().flatMap($ -> BlockPredicateExtensions.matchedBlocks($).stream()).distinct().map(class_1799::new).toList());
        });
        this.register(RecipeTypes.BLOCK_EXPLODING, new BlockExplodingRecipeCategory(), it -> {
            it.iconProvider = category -> {
                GuiGameElement.GuiRenderBuilder mainIcon = GuiGameElement.of((class_1935)class_1802.field_8626);
                return new SideBlockIcon(mainIcon, (Supplier<class_2680>)Suppliers.memoize(() -> RVs.getIconBlock(category.recipes())));
            };
            it.setSimpleWorkstationProvider(category -> List.of(class_1802.field_8626.method_7854()));
        });
        this.register(RecipeTypes.BLOCK_INTERACTING, new BlockInteractingRecipeCategory(), type -> {
            type.width += 30;
            type.iconProvider = category -> {
                AllGuiTextures mainIcon = category.recipes().stream().map($ -> ((BlockInteractingRecipe)$.comp_1933()).getType()).anyMatch($ -> $ == RecipeTypes.BLOCK_INTERACTING) ? AllGuiTextures.RIGHT_CLICK : AllGuiTextures.LEFT_CLICK;
                return new SideBlockIcon(mainIcon, (Supplier<class_2680>)Suppliers.memoize(() -> RVs.getIconBlock(category.recipes())));
            };
        });
        this.register(RecipeTypes.DRIPSTONE_DRIPPING, new DripstoneRecipeCategory(), it -> {
            it.iconProvider = category -> GuiGameElement.of((class_1935)class_1802.field_28042);
            it.setSimpleWorkstationProvider(category -> List.of(class_1802.field_28042.method_7854()));
        });
        this.register(RecipeTypes.LIGHTNING_CHANNELING, new LightningChannelingRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> GuiGameElement.of((class_1935)class_1802.field_27051);
            it.setSimpleWorkstationProvider(category -> List.of(class_1802.field_27051.method_7854()));
        });
        this.register(RecipeTypes.ITEM_EXPLODING, new ItemExplodingRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> GuiGameElement.of((class_1935)class_1802.field_8626);
            it.setSimpleWorkstationProvider(category -> List.of(class_1802.field_8626.method_7854()));
        });
        this.register(RecipeTypes.ITEM_BURNING, new ItemBurningRecipeCategory(), it -> {
            it.iconProvider = category -> new SideBlockIcon(AllGuiTextures.DOWN_ARROW, (Supplier<class_2680>)Suppliers.memoize(() -> ((class_2248)class_2246.field_10036).method_9564()));
        });
        this.register(RecipeTypes.ITEM_INSIDE, new ItemInsideRecipeCategory(), it -> {
            it.width = 170;
            it.iconProvider = category -> new SideBlockIcon(AllGuiTextures.DOWN_ARROW, (Supplier<class_2680>)Suppliers.memoize(() -> RVs.getIconBlock(category.recipes())));
        });
        for (LycheeRecipeType<? extends ILycheeRecipe<LycheeContext>> recipeType : RecipeTypes.ALL) {
            RvCategoryInstanceProviders.RvCategoryProvider<?> provider;
            RvCategory<?> category = this.categoryTypes.get(recipeType.categoryId);
            if (category == null || (provider = RvCategoryInstanceProviders.get(recipeType.categoryId)) == null) continue;
            Function factory = provider.get(category, (RvHelper)this.rvHelper);
            for (class_8786<? extends ILycheeRecipe<LycheeContext>> recipe : recipeType.inViewerRecipes()) {
                class_2960 id = RVs.composeCategoryIdentifier(recipeType.categoryId, class_2960.method_60654((String)((ILycheeRecipe)recipe.comp_1933()).group()));
                categories.computeIfAbsent(id, factory).addRecipe(recipe);
            }
        }
        this.categories = ImmutableMap.copyOf((Map)categories);
    }

    public ImmutableMap<class_2960, RvCategoryInstance<?>> categories() {
        return this.categories;
    }

    public <R extends ILycheeRecipe<LycheeContext>, T extends RvCategory<R>> void register(LycheeRecipeType<R> recipeType, T category, Consumer<T> configurer) {
        category.id = recipeType.categoryId;
        configurer.accept(category);
        Preconditions.checkNotNull(category.iconProvider, (String)"Icon provider is null: %s", (Object)category.id);
        category.init();
        Preconditions.checkArgument((this.categoryTypes.put(category.id, category) == null ? 1 : 0) != 0, (String)"Duplicate category type: %s", (Object)category.id);
    }

    public String toString() {
        return "RvPlugin{" + this.name + "}";
    }
}

