/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.DecorationMapBuilder;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.VectorExtensions;
import snownee.lychee.util.predicates.BlockPredicateExtensions;

public class BlockCrushingRecipeCategory
extends RvCategory<BlockCrushingRecipe> {
    private static final int FALLING_BLOCK_HEIGHT = 35;
    private static final int BLOCK_SIZE = 13;

    @Override
    public void setupDecorations(DecorationMapBuilder<BlockCrushingRecipe> mapBuilder) {
        mapBuilder.info(this::infoPosition);
        mapBuilder.consumeBlockInput($ -> VectorExtensions.offset((Vector2fc)this.landingBlockPosition((BlockCrushingRecipe)$), 13.0f, 3.0f));
        mapBuilder.put("falling_block", (builder, recipeHolder) -> {
            BlockCrushingRecipe recipe = (BlockCrushingRecipe)recipeHolder.comp_1933();
            boolean landingBlockIsAny = this.landingBlockIsAny(recipe);
            builder.addElement((RenderElement)((RenderElement)RenderElement.create((graphics, element) -> {
                float ticks = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
                ticks = Math.min(1.0f, ticks);
                ticks = ticks * ticks * ticks * ticks;
                class_4587 matrixStack = graphics.method_51448();
                matrixStack.method_22903();
                if (this.getLandingBlock(recipe).method_26213() < 5) {
                    matrixStack.method_22903();
                    float shadow = 0.5f;
                    int y = element.height();
                    if (landingBlockIsAny) {
                        shadow = 0.2f + ticks * 0.3f;
                    } else {
                        y += 13;
                    }
                    matrixStack.method_46416((float)element.width() / 2.0f, (float)y, 0.0f);
                    matrixStack.method_22905(shadow, shadow, shadow);
                    matrixStack.method_46416((float)(-AllGuiTextures.SHADOW.width) * 0.5f, (float)(-AllGuiTextures.SHADOW.height) * 0.5f, 0.0f);
                    AllGuiTextures.SHADOW.render((class_332)graphics);
                    matrixStack.method_22909();
                }
                matrixStack.method_22903();
                GuiGameElement.of(this.getFallingBlock(recipe)).scale(13.0).atLocal(0.0, (double)ticks * 1.3 + 0.4, 2.0).rotateBlock(20.0, 225.0, 0.0).lighting(RVs.BLOCK_LIGHTING).atZ(300.0f).render((class_332)graphics);
                matrixStack.method_22909();
                matrixStack.method_22909();
            }).at((Vector2fc)this.fallingBlockPosition(recipe))).withSize(13, 35));
            RvHelper helper = builder.helper();
            builder.addElement(((InteractiveRenderElement)((RenderElement)new InteractiveRenderElement().at((Vector2fc)this.fallingBlockPosition(recipe))).withSize(13, 35)).onTooltip(() -> BlockPredicateExtensions.getTooltips(this.getFallingBlock(recipe), recipe.blockPredicate(), helper)).onInput(helper.inputOnBlock(() -> this.getFallingBlock(recipe))));
        });
        mapBuilder.condition("landing_block", $ -> !this.landingBlockIsAny((BlockCrushingRecipe)$));
        mapBuilder.put("landing_block", (builder, recipeHolder) -> {
            BlockCrushingRecipe recipe = (BlockCrushingRecipe)recipeHolder.comp_1933();
            Vector2f landingBlockPosition = this.landingBlockPosition(recipe);
            builder.addElement((RenderElement)RenderElement.create((graphics, element) -> {
                class_4587 matrixStack = graphics.method_51448();
                matrixStack.method_22903();
                GuiGameElement.of(this.getLandingBlock(recipe)).scale(13.0).rotateBlock(20.0, 225.0, 0.0).lighting(RVs.BLOCK_LIGHTING).render((class_332)graphics);
                matrixStack.method_22909();
            }).at((Vector2fc)landingBlockPosition));
            RvHelper helper = builder.helper();
            builder.addElement(((InteractiveRenderElement)((RenderElement)new InteractiveRenderElement().at((Vector2fc)landingBlockPosition)).withSize(13)).onTooltip(() -> BlockPredicateExtensions.getTooltips(this.getLandingBlock(recipe), recipe.landingBlock(), helper)).onInput(helper.inputOnBlock(() -> this.getLandingBlock(recipe))));
        });
    }

    @Override
    public Vector2fc infoPosition(BlockCrushingRecipe recipe) {
        return VectorExtensions.offset((Vector2fc)this.fallingBlockPosition(recipe), 17.0f, 13.5f);
    }

    protected Vector2f landingBlockPosition(BlockCrushingRecipe recipe) {
        int xOffset = recipe.sizedIngredients().isEmpty() ? 40 : (this.width - 13) / 2;
        return new Vector2f((float)xOffset, 38.0f);
    }

    protected Vector2f fallingBlockPosition(BlockCrushingRecipe recipe) {
        float xOffset = this.landingBlockPosition((BlockCrushingRecipe)recipe).x;
        int yOffset = this.landingBlockIsAny(recipe) ? 50 : 38;
        return new Vector2f(xOffset, (float)(yOffset - 35));
    }

    protected boolean landingBlockIsAny(BlockCrushingRecipe recipe) {
        return BlockPredicateExtensions.isAny(recipe.landingBlock());
    }

    private class_2680 getFallingBlock(BlockCrushingRecipe recipe) {
        return CommonProxy.getCycledItem(BlockPredicateExtensions.getShowcaseBlockStates(recipe.blockPredicate()), class_2246.field_10124.method_9564(), 2000);
    }

    private class_2680 getLandingBlock(BlockCrushingRecipe recipe) {
        return CommonProxy.getCycledItem(BlockPredicateExtensions.getShowcaseBlockStates(recipe.landingBlock()), class_2246.field_10124.method_9564(), 2000);
    }

    public static InteractiveRenderElement icon(RenderElement element) {
        return (InteractiveRenderElement)((RenderElement)InteractiveRenderElement.create(graphics -> {
            float ticks = (float)(System.currentTimeMillis() % 3000L) / 1000.0f;
            float pos = 0.0f;
            if (ticks < 1.5f) {
                pos = ticks * ticks * ticks * ticks;
                pos *= 15.0f;
                if (ticks > 1.0f) {
                    pos -= 75.9375f;
                }
            }
            class_4587 pose = graphics.method_51448();
            pose.method_46416(0.0f, pos, 0.0f);
            element.render(graphics);
        }).withScissors(true).at((Vector2fc)element.position)).withSize((Vector2ic)element.size);
    }
}

