/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryDecoration;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstanceImpl;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.ui.CategoryModifier;

public abstract class RvCategoryBuilder<R extends ILycheeRecipe<LycheeContext>> {
    private final RvCategoryInstance<R> instance;
    private boolean renderDefault;
    private final Map<String, RvCategoryDecoration<R>> decorations = Maps.newHashMap();

    protected RvCategoryBuilder(RvCategoryInstance<R> instance, class_8786<R> recipeHolder) {
        this.instance = instance;
        this.decorations.putAll(instance.decorations());
        String id = recipeHolder.comp_1932().toString();
        List<CategoryModifier> modifiers = instance.modifiers().stream().map(class_8786::comp_1933).filter($ -> $.recipe().test(id)).toList();
        this.renderDefault = instance.renderDefault();
        for (CategoryModifier modifier : modifiers) {
            RvCategoryInstanceImpl.processDecorations(modifier.elements().orElse(null), this.decorations);
            this.renderDefault = this.renderDefault || modifier.renderDefault();
        }
    }

    public RvCategoryInstance<?> instance() {
        return this.instance;
    }

    public RvCategory<?> type() {
        return this.instance().type();
    }

    public RvHelper helper() {
        return this.instance().helper();
    }

    public int width() {
        return this.instance().width();
    }

    public int height() {
        return this.instance().height();
    }

    public Map<String, RvCategoryDecoration<R>> decorations() {
        return this.decorations;
    }

    @Nullable
    public Predicate<R> condition(String key) {
        return this.instance.conditions().get(key);
    }

    public boolean renderDefault() {
        return this.renderDefault;
    }
}

