/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.category;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryDecoration;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryWidgetBuilder;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.ui.CategoryMetadata;
import snownee.lychee.util.ui.CategoryModifier;
import snownee.lychee.util.ui.ElementRenderer;
import snownee.lychee.util.ui.UIElement;

public class RvCategoryInstanceImpl<R extends ILycheeRecipe<LycheeContext>>
implements RvCategoryInstance<R> {
    private final RvCategory<R> type;
    private final RvHelper helper;
    private final class_2960 id;
    protected final class_8786<CategoryMetadata> metadata;
    protected final List<class_8786<CategoryModifier>> modifiers;
    private final List<class_8786<R>> recipes = Lists.newArrayList();
    private final Map<String, RvCategoryDecoration<R>> decorations = Maps.newLinkedHashMap();
    private final Map<String, Predicate<R>> conditions = Maps.newLinkedHashMap();

    public RvCategoryInstanceImpl(RvCategory<R> type, class_2960 id, RvHelper helper) {
        this.type = type;
        this.id = id;
        this.helper = helper;
        this.metadata = helper.getMetadata(this);
        this.modifiers = helper.getModifiers(this);
        this.decorations.putAll((Map<String, RvCategoryDecoration<R>>)type.decorations);
        this.conditions.putAll((Map<String, Predicate<R>>)type.conditions);
        RvCategoryInstanceImpl.processDecorations(this.metadata().elements().orElse(null), this.decorations);
    }

    @Override
    public final RvCategory<R> type() {
        return this.type;
    }

    @Override
    public class_2960 id() {
        return this.id;
    }

    @Override
    public RvHelper helper() {
        return this.helper;
    }

    @Override
    public List<class_8786<R>> recipes() {
        return this.recipes;
    }

    @Override
    public CategoryMetadata metadata() {
        return (CategoryMetadata)this.metadata.comp_1933();
    }

    @Override
    public List<class_8786<CategoryModifier>> modifiers() {
        return this.modifiers;
    }

    @Override
    public RenderElement icon() {
        return this.metadata().icon().map(ElementRenderer::of).orElseGet(() -> RvCategoryInstance.super.icon());
    }

    @Override
    public List<class_1856> workstations() {
        return this.metadata().workstation().orElseGet(() -> RvCategoryInstance.super.workstations());
    }

    @Override
    public int width() {
        Vector2ic size = this.metadata().size().orElse(null);
        return size == null ? RvCategoryInstance.super.width() : size.x();
    }

    @Override
    public int height() {
        Vector2ic size = this.metadata().size().orElse(null);
        return size == null ? RvCategoryInstance.super.height() : size.y();
    }

    @Override
    public boolean renderDefault() {
        return this.metadata().renderDefault();
    }

    @Override
    public Map<String, RvCategoryDecoration<R>> decorations() {
        return this.decorations;
    }

    @Override
    public Map<String, Predicate<R>> conditions() {
        return this.conditions;
    }

    @Override
    public void configureDecorations(RvCategoryWidgetBuilder<R> builder, class_8786<R> recipeHolder) {
        for (Map.Entry entry : builder.decorations().entrySet()) {
            Predicate condition;
            String key = entry.getKey();
            if (!builder.renderDefault() && this.type.decorations.containsKey((Object)key) || (condition = builder.condition(key)) != null && !condition.test((ILycheeRecipe)recipeHolder.comp_1933())) continue;
            entry.getValue().setup(builder, recipeHolder);
        }
    }

    public static <R extends ILycheeRecipe<LycheeContext>> void processDecorations(@Nullable Map<String, List<UIElement>> uiElements, Map<String, RvCategoryDecoration<R>> decorations) {
        if (uiElements == null) {
            return;
        }
        for (Map.Entry<String, List<UIElement>> entry : uiElements.entrySet()) {
            String key = entry.getKey();
            List<UIElement> elements = entry.getValue();
            RvCategoryDecoration decoration = (builder, recipeHolder) -> {
                for (UIElement element : elements) {
                    builder.addElement(ElementRenderer.of(element, recipeHolder));
                }
            };
            decorations.put(key, decoration);
        }
    }
}

