/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.class_1856;
import net.minecraft.class_8786;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RvPlugin;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.emi.category.EmiRvHelper;
import snownee.lychee.compat.recipeviewer.emi.category.RvCategoryAdapter;
import snownee.lychee.compat.recipeviewer.emi.element.EmiWidgetAdapter;
import snownee.lychee.compat.recipeviewer.emi.recipe.EmiRecipeAdapter;
import snownee.lychee.compat.recipeviewer.emi.recipe.LycheeEmiAnvilRecipe;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.recipes.ShapedCraftingRecipe;
import snownee.lychee.util.recipe.ILycheeRecipe;

@EmiEntrypoint
public class LycheeEMIPlugin
implements EmiPlugin {
    private final RvPlugin<EmiRvHelper> rvPlugin = new RvPlugin<EmiRvHelper>(EmiRvHelper.INSTANCE);

    public void register(EmiRegistry registry) {
        this.rvPlugin.init();
        for (RvCategoryInstance rvCategoryInstance : this.rvPlugin.categories().values()) {
            RvCategoryAdapter category = new RvCategoryAdapter(rvCategoryInstance);
            registry.addCategory(category);
            for (class_1856 class_18562 : rvCategoryInstance.workstations()) {
                registry.addWorkstation(category, EmiIngredient.of((class_1856)class_18562));
            }
            for (class_8786 class_87862 : rvCategoryInstance.recipes()) {
                registry.addRecipe(new EmiRecipeAdapter(category, class_87862));
            }
        }
        for (class_8786 class_87863 : RecipeTypes.ANVIL_CRAFTING.inViewerRecipes()) {
            registry.addRecipe((EmiRecipe)new LycheeEmiAnvilRecipe((class_8786<AnvilCraftingRecipe>)class_87863));
        }
        registry.addRecipeDecorator(VanillaEmiRecipeCategories.CRAFTING, (emiRecipe, widgets) -> {
            class_8786 recipeHolder = emiRecipe.getBackingRecipe();
            if (recipeHolder == null || !(recipeHolder.comp_1933() instanceof ShapedCraftingRecipe)) {
                return;
            }
            LycheeEMIPlugin.addInfoIcon(widgets, recipeHolder, 60, 18);
        });
    }

    public static void addInfoIcon(WidgetHolder widgets, class_8786<? extends ILycheeRecipe<?>> recipe, int x, int y) {
        if (!RvCategory.needInfo((ILycheeRecipe)recipe.comp_1933())) {
            return;
        }
        y = Math.max(y - 9, 0);
        widgets.add((Widget)new EmiWidgetAdapter((RenderElement)RvCategory.infoIcon(recipe).at(x += EmiTexture.EMPTY_ARROW.regionWidth / 2 - 4, y)));
    }
}

