/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.jei.category;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.common.input.IInternalKeyMappings;
import net.minecraft.class_1799;
import net.minecraft.class_3611;
import net.minecraft.class_3675;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.ui.InputAction;

public class JeiRvHelper
extends RvHelper {
    public static final JeiRvHelper INSTANCE = new JeiRvHelper();
    @Nullable
    private IJeiRuntime runtime;
    @Nullable
    private IJeiHelpers jeiHelpers;

    @Override
    public boolean doAction(class_1799 stack, InputAction.Direct action) {
        if (this.runtime == null) {
            return false;
        }
        if (action == InputAction.Direct.SHOW_USAGES || action == InputAction.Direct.SHOW_RECIPES) {
            RecipeIngredientRole role;
            IRecipesGui recipesGui = this.runtime.getRecipesGui();
            IFocusFactory focusFactory = this.runtime.getJeiHelpers().getFocusFactory();
            RecipeIngredientRole recipeIngredientRole = role = action == InputAction.Direct.SHOW_USAGES ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
            if (!stack.method_7960()) {
                recipesGui.show(focusFactory.createFocus(role, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doAction(class_3611 fluid, InputAction.Direct action) {
        if (this.runtime == null) {
            return false;
        }
        if (action == InputAction.Direct.SHOW_USAGES || action == InputAction.Direct.SHOW_RECIPES) {
            IRecipesGui recipesGui = this.runtime.getRecipesGui();
            IJeiHelpers helpers = this.runtime.getJeiHelpers();
            IPlatformFluidHelper fluidHelper = helpers.getPlatformFluidHelper();
            IFocusFactory focusFactory = helpers.getFocusFactory();
            RecipeIngredientRole role = action == InputAction.Direct.SHOW_USAGES ? RecipeIngredientRole.INPUT : RecipeIngredientRole.OUTPUT;
            recipesGui.show(focusFactory.createFocus(role, (IIngredientType)fluidHelper.getFluidIngredientType(), (Object)((IJeiFluidIngredient)fluidHelper.create((class_6880)fluid.method_40178(), fluidHelper.bucketVolume()))));
            return true;
        }
        return false;
    }

    @Override
    public Optional<InputAction.Direct> toDirectAction(InputAction action) {
        if (action instanceof InputAction.Direct) {
            InputAction.Direct direct = (InputAction.Direct)action;
            return Optional.of(direct);
        }
        if (this.runtime == null) {
            return Optional.empty();
        }
        try {
            IInternalKeyMappings keyMappings = (IInternalKeyMappings)this.runtime.getKeyMappings();
            List<Map.Entry<IJeiKeyMapping, InputAction.Direct>> keys = List.of(Map.entry(keyMappings.getShowRecipe(), InputAction.Direct.SHOW_RECIPES), Map.entry(keyMappings.getShowUses(), InputAction.Direct.SHOW_USAGES), Map.entry(keyMappings.getBookmark(), InputAction.Direct.FAVORITE));
            for (Map.Entry<IJeiKeyMapping, InputAction.Direct> entry : keys) {
                class_3675.class_306 key = action.keyMapping();
                if (key == class_3675.field_16237 || !entry.getKey().isActiveAndMatches(key)) continue;
                return Optional.ofNullable(entry.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public boolean appendModName() {
        if (ClientProxy.hasJade && IWailaConfig.get().getGeneral().showItemModNameTooltip()) {
            return true;
        }
        return this.jeiHelpers != null && this.jeiHelpers.getModIdHelper().isDisplayingModNameEnabled();
    }

    @ApiStatus.Internal
    public void setRuntime(@Nullable IJeiRuntime runtime) {
        this.runtime = runtime;
    }

    @ApiStatus.Internal
    public void setJeiHelpers(@Nullable IJeiHelpers jeiHelpers) {
        this.jeiHelpers = jeiHelpers;
    }

    public IJeiRuntime jeiRuntime() {
        return Objects.requireNonNull(this.runtime);
    }

    public IJeiHelpers jeiHelpers() {
        return Objects.requireNonNull(this.jeiHelpers);
    }
}

