/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.jei.category;

import com.google.common.collect.Maps;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_4550;
import net.minecraft.class_746;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2fc;
import snownee.lychee.action.DropItem;
import snownee.lychee.action.RandomSelect;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.IngredientInfo;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.SlotType;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryLayoutBuilder;
import snownee.lychee.compat.recipeviewer.category.RvCategoryWidgetBuilder;
import snownee.lychee.compat.recipeviewer.jei.LycheeJEIPlugin;
import snownee.lychee.compat.recipeviewer.jei.category.JeiRvHelper;
import snownee.lychee.compat.recipeviewer.jei.element.RenderElementAdapter;
import snownee.lychee.compat.recipeviewer.jei.ingredient.PostActionIngredientRenderer;
import snownee.lychee.util.action.ActionRenderer;
import snownee.lychee.util.action.CompoundAction;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class RvCategoryAdapter<R extends ILycheeRecipe<LycheeContext>>
implements IRecipeCategory<class_8786<R>> {
    private final RvCategoryInstance<R> instance;
    private final RecipeType<class_8786<R>> type;
    private final IDrawable icon;

    public RvCategoryAdapter(RvCategoryInstance<R> instance) {
        this.instance = instance;
        this.type = RecipeType.createRecipeHolderType((class_2960)instance.id());
        this.icon = new RenderElementAdapter(instance.icon());
    }

    private void addBlockIngredients(IRecipeLayoutBuilder builder, ILycheeRecipe<LycheeContext> recipe) {
        this.addBlockIngredients(builder, recipe.getBlockInputs(), RecipeIngredientRole.INPUT);
        this.addBlockIngredients(builder, recipe.getBlockOutputs(), RecipeIngredientRole.OUTPUT);
    }

    private void addBlockIngredients(IRecipeLayoutBuilder builder, Iterable<class_4550> blocks, RecipeIngredientRole role) {
        for (class_4550 block : blocks) {
            List<class_1799> items = BlockPredicateExtensions.matchedItemStacks(block);
            Set<class_3611> fluids = BlockPredicateExtensions.matchedFluids(block);
            if (items.isEmpty() && fluids.isEmpty()) continue;
            IIngredientAcceptor acceptor = builder.addInvisibleIngredients(role);
            acceptor.addItemStacks(items);
            fluids.forEach(fluid -> acceptor.addFluidStack(fluid, ((JeiRvHelper)this.instance.helper()).jeiHelpers().getPlatformFluidHelper().bucketVolume()));
        }
    }

    private static <T> void slotGroup(IRecipeLayoutBuilder builder, float x, float y, List<T> items, SlotLayoutFunction<T> layoutFunction) {
        int size = Math.min(items.size(), 9);
        int gridX = (int)Math.ceil(Math.sqrt(size));
        int gridY = (int)Math.ceil((float)size / (float)gridX);
        x -= (float)(gridX * 9);
        y -= (float)(gridY * 9);
        int index = 0;
        for (int i = 0; i < gridY; ++i) {
            for (int j = 0; j < gridX && index < size; ++index, ++j) {
                layoutFunction.apply(builder, items.get(index), x + (float)(j * 19), y + (float)(i * 19));
            }
        }
    }

    private void actionSlot(IRecipeLayoutBuilder builder, PostAction action, float x, float y) {
        IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, (int)(x + 1.0f), (int)(y + 1.0f));
        IdentityHashMap itemMap = Maps.newIdentityHashMap();
        this.buildActionSlot(builder, slotBuilder, action, itemMap);
        slotBuilder.addRichTooltipCallback((view, tooltip) -> {
            List<class_2561> list;
            Optional displayedIngredient = view.getDisplayedIngredient();
            if (displayedIngredient.isEmpty()) {
                return;
            }
            Object raw = ((ITypedIngredient)displayedIngredient.get()).getIngredient();
            if (!itemMap.containsKey(raw)) {
                return;
            }
            tooltip.clear();
            raw = itemMap.get(raw);
            class_746 player = class_310.method_1551().field_1724;
            if (action instanceof RandomSelect) {
                RandomSelect randomSelect = (RandomSelect)action;
                list = ActionRenderer.getTooltipsFromRandom(randomSelect, (PostAction)raw, (class_1657)player);
            } else {
                list = ActionRenderer.of(action).getTooltips(action, (class_1657)player);
            }
            tooltip.addAll(list);
        });
        SlotType slotType = action.conditions().showingCount() == 0 ? SlotType.NORMAL : SlotType.CHANCE;
        slotBuilder.setBackground(LycheeJEIPlugin.slot(slotType), -1, -1);
    }

    private void buildActionSlot(IRecipeLayoutBuilder builder, IRecipeSlotBuilder slotBuilder, final PostAction action, Map<class_1799, PostAction> itemMap) {
        PostAction postAction = action;
        Objects.requireNonNull(postAction);
        PostAction postAction2 = postAction;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DropItem.class, CompoundAction.class}, (Object)postAction2, n)) {
            case 0: {
                DropItem dropItem = (DropItem)postAction2;
                slotBuilder.addItemStack(dropItem.itemStack());
                if (action.commonProperties().icon() != null) {
                    slotBuilder.setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<class_1799>(){

                        public void render(class_332 guiGraphics, class_1799 ingredient) {
                            PostActionIngredientRenderer.INSTANCE.render(guiGraphics, action);
                        }

                        public void getTooltip(ITooltipBuilder tooltip, class_1799 ingredient, class_1836 tooltipFlag) {
                            IIngredientManager ingredientManager = ((JeiRvHelper)RvCategoryAdapter.this.instance.helper()).jeiHelpers().getIngredientManager();
                            ingredientManager.getIngredientRenderer((Object)ingredient).getTooltip(tooltip, (Object)ingredient, tooltipFlag);
                        }

                        public List<class_2561> getTooltip(class_1799 ingredient, class_1836 tooltipFlag) {
                            return List.of();
                        }
                    });
                }
                itemMap.put(dropItem.itemStack(), dropItem);
                break;
            }
            case 1: {
                CompoundAction compoundAction = (CompoundAction)((Object)postAction2);
                compoundAction.getChildActions().filter(it -> !it.hidden()).forEach(child -> this.buildActionSlot(builder, slotBuilder, (PostAction)child, itemMap));
                break;
            }
            default: {
                slotBuilder.addIngredient(LycheeJEIPlugin.POST_ACTION, (Object)action);
                List<class_1799> outputItems = action.getOutputItems();
                if (outputItems.isEmpty()) break;
                builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStacks(outputItems);
            }
        }
    }

    public RecipeType<class_8786<R>> getRecipeType() {
        return this.type;
    }

    public class_2561 getTitle() {
        return this.instance.title();
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return this.instance.width();
    }

    public int getHeight() {
        return this.instance.height();
    }

    private void actionGroup(IRecipeLayoutBuilder builder, R recipe, float x, float y) {
        RvCategoryAdapter.slotGroup(builder, x, y, recipe.postActions().stream().filter(it -> !it.hidden()).toList(), this::actionSlot);
    }

    private void ingredientGroup(IRecipeLayoutBuilder builder, R recipe, float x, float y) {
        List<IngredientInfo> ingredients = RVs.generateShapelessInputs(recipe);
        RvCategoryAdapter.slotGroup(builder, x + 1.0f, y + 1.0f, ingredients, (layout0, ingredient, x0, y0) -> {
            IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, (int)x0, (int)y0);
            if (ingredient.ingredient.method_8103()) {
                if (!ingredient.tooltips.isEmpty()) {
                    slotBuilder.addIngredient(LycheeJEIPlugin.POST_ACTION, (Object)PostActionIngredientRenderer.INGREDIENT_HACK_DUMMY);
                }
            } else if (ingredient.count == 1) {
                slotBuilder.addIngredients(ingredient.ingredient);
            } else {
                slotBuilder.addItemStacks(Arrays.stream(ingredient.ingredient.method_8105()).map(it -> it.method_46651(ingredient.count)).toList());
            }
            slotBuilder.setBackground(LycheeJEIPlugin.slot(ingredient.type), -1, -1);
            if (!ingredient.tooltips.isEmpty()) {
                slotBuilder.addRichTooltipCallback((stack, tooltip) -> tooltip.addAll(ingredient.tooltips));
            }
        });
    }

    public void setRecipe(final IRecipeLayoutBuilder builder, final class_8786<R> recipeHolder, IFocusGroup focuses) {
        RvCategoryLayoutBuilder.Wrapped layoutBuilder = new RvCategoryLayoutBuilder.Wrapped<R>(this.instance, recipeHolder){

            @Override
            protected void _actionGroup(R recipe, Vector2fc position) {
                RvCategoryAdapter.this.actionGroup(builder, (ILycheeRecipe)recipeHolder.comp_1933(), position.x(), position.y());
            }

            @Override
            protected void _ingredientGroup(R recipe, Vector2fc position) {
                RvCategoryAdapter.this.ingredientGroup(builder, (ILycheeRecipe)recipeHolder.comp_1933(), position.x(), position.y());
            }
        };
        this.instance.type().configureLayout(layoutBuilder, recipeHolder);
        this.addBlockIngredients(builder, (ILycheeRecipe)recipeHolder.comp_1933());
    }

    public void createRecipeExtras(final IRecipeExtrasBuilder builder, class_8786<R> recipe, IFocusGroup focuses) {
        super.createRecipeExtras(builder, recipe, focuses);
        RvCategoryWidgetBuilder widgetBuilder = new RvCategoryWidgetBuilder<R>(this, this.instance, recipe){

            @Override
            public void addElement(RenderElement element) {
                RenderElementAdapter adapter = new RenderElementAdapter(element);
                builder.addWidget((IRecipeWidget)adapter);
                builder.addGuiEventListener((IJeiGuiEventListener)adapter);
            }
        };
        this.instance.configureDecorations(widgetBuilder, recipe);
    }

    @FunctionalInterface
    static interface SlotLayoutFunction<T> {
        public void apply(IRecipeLayoutBuilder var1, T var2, float var3, float var4);
    }
}

