/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.rei.category;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import snownee.lychee.action.DropItem;
import snownee.lychee.action.RandomSelect;
import snownee.lychee.client.gui.InteractiveRenderElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.client.gui.WrapperRenderElement;
import snownee.lychee.compat.recipeviewer.IngredientInfo;
import snownee.lychee.compat.recipeviewer.RVs;
import snownee.lychee.compat.recipeviewer.SlotType;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.category.RvCategoryLayoutBuilder;
import snownee.lychee.compat.recipeviewer.category.RvCategoryWidgetBuilder;
import snownee.lychee.compat.recipeviewer.rei.LycheeREIPlugin;
import snownee.lychee.compat.recipeviewer.rei.display.LycheeDisplay;
import snownee.lychee.compat.recipeviewer.rei.element.LycheeEntryWidget;
import snownee.lychee.compat.recipeviewer.rei.element.RenderElementAdapter;
import snownee.lychee.ui.TextElementRenderer;
import snownee.lychee.util.action.ActionRenderer;
import snownee.lychee.util.action.CompoundAction;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.ui.InputAction;

public class RvCategoryAdapter<R extends ILycheeRecipe<LycheeContext>>
implements DisplayCategory<LycheeDisplay<R>> {
    private final RvCategoryInstance<R> instance;
    private final CategoryIdentifier<LycheeDisplay<R>> categoryIdentifier;
    private final Renderer icon;

    public RvCategoryAdapter(RvCategoryInstance<R> instance) {
        this.instance = instance;
        this.categoryIdentifier = CategoryIdentifier.of((class_2960)instance.id());
        this.icon = new RenderElementAdapter(instance.icon());
    }

    static <T> void slotGroup(ImmutableList.Builder<Widget> widgets, Vector2fc startPoint, float x, float y, List<T> items, SlotLayoutFunction<T> layoutFunction) {
        int size = Math.min(items.size(), 9);
        int gridX = (int)Math.ceil(Math.sqrt(size));
        int gridY = (int)Math.ceil((float)size / (float)gridX);
        x -= (float)(gridX * 9);
        y -= (float)(gridY * 9);
        int index = 0;
        for (int i = 0; i < gridY; ++i) {
            for (int j = 0; j < gridX && index < size; ++index, ++j) {
                layoutFunction.apply(widgets, startPoint, items.get(index), (int)(x + (float)(j * 19)), (int)(y + (float)(i * 19)));
            }
        }
    }

    static void actionSlot(ImmutableList.Builder<Widget> widgets, Vector2fc startPoint, PostAction action, int x, int y) {
        LycheeEntryWidget slot = LycheeREIPlugin.slot(startPoint, x, y, action.conditions().showingCount() == 0 ? SlotType.NORMAL : SlotType.CHANCE);
        slot.markOutput();
        ArrayList entries = Lists.newArrayList();
        HashMap itemMap = Maps.newHashMap();
        RvCategoryAdapter.buildActionSlot(entries, action, itemMap);
        slot.entries(entries);
        widgets.add((Object)slot);
        slot.tooltipProcessor(tooltip -> {
            List<class_2561> list;
            if (tooltip == null) {
                return null;
            }
            Object raw = tooltip.getContextStack();
            if (!itemMap.containsKey(raw)) {
                return tooltip;
            }
            tooltip.entries().clear();
            raw = itemMap.get(raw);
            class_746 player = class_310.method_1551().field_1724;
            if (action instanceof RandomSelect) {
                RandomSelect randomSelect = (RandomSelect)action;
                list = ActionRenderer.getTooltipsFromRandom(randomSelect, (PostAction)raw, (class_1657)player);
            } else {
                list = ActionRenderer.of(action).getTooltips(action, (class_1657)player);
            }
            tooltip.entries().addAll(list.stream().map(Tooltip::entry).toList());
            return tooltip;
        });
    }

    static void buildActionSlot(List<EntryStack<?>> entries, PostAction action, Map<EntryStack<class_1799>, PostAction> itemMap) {
        final EntryStack entry = EntryStack.of(LycheeREIPlugin.POST_ACTION, (Object)action);
        PostAction postAction = action;
        Objects.requireNonNull(postAction);
        PostAction postAction2 = postAction;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DropItem.class, CompoundAction.class}, (Object)postAction2, n)) {
            case 0: {
                DropItem dropitem = (DropItem)postAction2;
                EntryStack itemEntry = EntryStacks.of((class_1799)dropitem.itemStack());
                if (action.commonProperties().icon() != null) {
                    final EntryRenderer originalRenderer = itemEntry.getRenderer();
                    itemEntry.withRenderer((EntryRenderer)new EntryRenderer<class_1799>(){

                        public void render(EntryStack<class_1799> entryStack, class_332 guiGraphics, Rectangle rectangle, int mx, int my, float delta) {
                            entry.getRenderer().render(entry, guiGraphics, rectangle, mx, my, delta);
                        }

                        @Nullable
                        public Tooltip getTooltip(EntryStack<class_1799> entryStack, TooltipContext tooltipContext) {
                            return originalRenderer.getTooltip(entryStack, tooltipContext);
                        }
                    });
                }
                entries.add(itemEntry);
                itemMap.put((EntryStack<class_1799>)itemEntry, dropitem);
                break;
            }
            case 1: {
                CompoundAction compoundAction = (CompoundAction)((Object)postAction2);
                compoundAction.getChildActions().filter(it -> !it.hidden()).forEach(child -> RvCategoryAdapter.buildActionSlot(entries, child, itemMap));
                break;
            }
            default: {
                entries.add(entry);
            }
        }
    }

    public CategoryIdentifier<? extends LycheeDisplay<R>> getCategoryIdentifier() {
        return this.categoryIdentifier;
    }

    public class_2561 getTitle() {
        return this.instance.title();
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public int getDisplayWidth(LycheeDisplay<R> display) {
        return this.instance.width() + 10;
    }

    public int getDisplayHeight() {
        return this.instance.height() + 6;
    }

    private void actionGroup(ImmutableList.Builder<Widget> widgets, Vector2fc startPoint, R recipe, float x, float y) {
        RvCategoryAdapter.slotGroup(widgets, startPoint, x, y, recipe.postActions().stream().filter(it -> !it.hidden()).toList(), RvCategoryAdapter::actionSlot);
    }

    private void ingredientGroup(ImmutableList.Builder<Widget> widgets, Vector2fc startPoint, R recipe, float x, float y) {
        List<IngredientInfo> ingredients = RVs.generateShapelessInputs(recipe);
        RvCategoryAdapter.slotGroup(widgets, startPoint, x, y, ingredients, (widgets0, startPoint0, ingredient, x0, y0) -> {
            LycheeEntryWidget slot = LycheeREIPlugin.slot(startPoint, x0, y0, ingredient.type);
            if (ingredient.count == 1) {
                slot.entries((Collection)EntryIngredients.ofIngredient((class_1856)ingredient.ingredient));
            } else {
                slot.entries((Collection)EntryIngredients.ofItemStacks(Stream.of(ingredient.ingredient.method_8105()).map($ -> $.method_46651(ingredient.count)).toList()));
            }
            slot.markInput();
            slot.setExtraTooltips(ingredient.tooltips);
            widgets.add((Object)slot);
        });
    }

    public List<Widget> setupDisplay(LycheeDisplay<R> display, Rectangle bounds) {
        final ImmutableList.Builder widgets = ImmutableList.builder();
        final Vector2f startPoint = new Vector2f((float)bounds.getCenterX() - (float)this.instance.width() / 2.0f, (float)bounds.getCenterY() - (float)this.instance.height() / 2.0f + 1.0f);
        widgets.add((Object)Widgets.createRecipeBase((Rectangle)bounds));
        RvCategoryLayoutBuilder.Wrapped layoutBuilder = new RvCategoryLayoutBuilder.Wrapped<R>(this.instance, display.recipe()){

            @Override
            protected void _actionGroup(R recipe, Vector2fc position) {
                RvCategoryAdapter.this.actionGroup((ImmutableList.Builder<Widget>)widgets, (Vector2fc)startPoint, recipe, position.x(), position.y());
            }

            @Override
            protected void _ingredientGroup(R recipe, Vector2fc position) {
                RvCategoryAdapter.this.ingredientGroup((ImmutableList.Builder<Widget>)widgets, (Vector2fc)startPoint, recipe, position.x(), position.y());
            }
        };
        this.instance.type().configureLayout(layoutBuilder, display.recipe());
        RvCategoryWidgetBuilder widgetBuilder = new RvCategoryWidgetBuilder<R>(this, this.instance, display.recipe()){

            @Override
            public void addElement(RenderElement element) {
                ScreenElement unwrapped = WrapperRenderElement.unwrap(element);
                if (unwrapped instanceof TextElementRenderer) {
                    TextElementRenderer text = (TextElementRenderer)unwrapped;
                    text.offset((Vector2fc)startPoint);
                    Point point = new Point((double)element.x(), (double)element.y());
                    Label widget = Widgets.createLabel((Point)point, (class_2561)(REIRuntime.getInstance().isDarkThemeEnabled() ? text.darkText : text.text));
                    if (text.text != text.darkText) {
                        widget.setOnRender((graphics, label) -> {
                            class_2561 msg;
                            class_2561 class_25612 = msg = REIRuntime.getInstance().isDarkThemeEnabled() ? text.darkText : text.text;
                            if (msg != label.getMessage()) {
                                label.setMessage((class_5348)msg);
                            }
                        });
                    }
                    widget.shadow(text.shadow);
                    widget.color(text.lightModeColor, text.darkModeColor);
                    if (text.centered) {
                        widget.centered();
                    }
                    if (element instanceof InteractiveRenderElement) {
                        InteractiveRenderElement interactive = (InteractiveRenderElement)element;
                        widget.setTooltipFunction(it -> {
                            List<class_2561> tooltip = interactive.getTooltip();
                            if (tooltip == null) {
                                return null;
                            }
                            return (class_2561[])tooltip.toArray(class_2561[]::new);
                        });
                        BiPredicate<InputAction, @Nullable InteractiveRenderElement> onInput = interactive.getOnInput();
                        if (onInput != null) {
                            widget.clickable();
                            widget.setOnClick(it -> onInput.test(InputAction.mousePressed(0), null));
                        }
                    }
                    widgets.add((Object)widget);
                    return;
                }
                widgets.add((Object)new RenderElementAdapter(element, (Vector2fc)startPoint));
            }
        };
        this.instance.configureDecorations(widgetBuilder, display.recipe());
        return widgets.build();
    }

    @FunctionalInterface
    static interface SlotLayoutFunction<T> {
        public void apply(ImmutableList.Builder<Widget> var1, Vector2fc var2, T var3, int var4, int var5);
    }
}

