/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.context;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_169;
import net.minecraft.class_176;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_8567;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.context.LootParamInit;

public class LootParamsContext {
    private final Map<class_169<?>, @Nullable Object> params = new IdentityHashMap();
    private final class_1937 level;
    private final class_176 paramSet;
    private boolean validated;

    public LootParamsContext(class_1937 level, class_176 paramSet) {
        this.level = level;
        this.paramSet = paramSet;
    }

    public Map<class_169<?>, @Nullable Object> params() {
        return this.params;
    }

    public class_176 paramSet() {
        return this.paramSet;
    }

    public boolean has(class_169<?> param) {
        return this.params.get(param) != null;
    }

    public <T> T get(class_169<T> param) {
        T result = this.getOrNull(param);
        if (result == null) {
            throw new NoSuchElementException(param.method_746().toString());
        }
        return result;
    }

    @Nullable
    public <T> T getOrNull(class_169<T> param) {
        return (T)this.params.computeIfAbsent(param, this::init);
    }

    public <T> void set(class_169<T> param, @Nullable T value) {
        this.params.put(param, value);
        if (this.validated && param == class_181.field_24424) {
            for (class_169<?> initParam : LootParamInit.LOOKUP.keySet()) {
                if (initParam == class_181.field_24424) continue;
                this.params.remove(initParam);
            }
        }
    }

    public void remove(class_169<?> param) {
        this.set(param, null);
    }

    public class_47 asLootContext() {
        this.initAll();
        class_8567.class_8568 paramsBuilder = new class_8567.class_8568((class_3218)this.level);
        this.params.forEach((p, o) -> {
            if (o != null) {
                paramsBuilder.method_51874(p, o);
            }
        });
        class_47.class_48 builder = new class_47.class_48(paramsBuilder.method_51875(LycheeLootContextParamSets.ALL));
        return builder.method_309(Optional.empty());
    }

    public void validate() {
        this.validate(this.paramSet);
    }

    public void validate(class_176 paramSet) {
        Sets.SetView difference = Sets.difference((Set)paramSet.method_778(), this.params.keySet());
        if (!difference.isEmpty()) {
            throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(difference));
        }
        this.validated = true;
    }

    public void initAll() {
        for (class_169<?> param : LootParamInit.LOOKUP.keySet()) {
            this.getOrNull(param);
        }
    }

    @Nullable
    @CheckReturnValue
    public Object init(class_169<?> param) {
        LootParamInit init = LootParamInit.LOOKUP.get(param);
        if (init != null) {
            return init.init(this.level, this);
        }
        return null;
    }
}

