/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_181;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.recipe.ILycheeRecipe;

public class DirectionCheck
implements ContextualCondition {
    public static final Map<String, DirectionCheck> LOOKUPS = Maps.newHashMap();
    private final String name;
    private final Predicate<LycheeContext> predicate;

    public static void createLookup(String name, Predicate<LycheeContext> predicate) {
        LOOKUPS.put(name, new DirectionCheck(name, predicate));
    }

    private DirectionCheck(String name, Predicate<LycheeContext> predicate) {
        this.name = name;
        this.predicate = predicate;
    }

    public ContextualConditionType<DirectionCheck> type() {
        return ContextualConditionType.DIRECTION;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.predicate.test(ctx) ? times : 0;
    }

    @Override
    public class_5250 getDescription(boolean inverted) {
        class_5250 value = class_2561.method_43471((String)("direction.lychee." + this.name)).method_27692(class_124.field_1068);
        return class_2561.method_43469((String)this.getDescriptionId(inverted), (Object[])new Object[]{value});
    }

    static {
        for (class_2350 direction : class_2350.values()) {
            DirectionCheck.createLookup(direction.method_10151().toLowerCase(Locale.ENGLISH), ctx -> ctx.get(LycheeContextKey.LOOT_PARAMS).get(LycheeLootContextParams.DIRECTION) == direction);
        }
        DirectionCheck.createLookup("sides", ctx -> ctx.get(LycheeContextKey.LOOT_PARAMS).get(LycheeLootContextParams.DIRECTION).method_10164() == 0);
        DirectionCheck.createLookup("forward", ctx -> {
            class_2680 state;
            class_2350 facing;
            LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
            class_2350 direction = lootParams.get(LycheeLootContextParams.DIRECTION);
            return direction == (facing = (class_2350)(state = (class_2680)lootParams.get(class_181.field_1224)).method_28500((class_2769)class_2741.field_12525).or(() -> state.method_28500((class_2769)class_2741.field_12481)).or(() -> state.method_28500((class_2769)class_2741.field_28062)).orElseThrow());
        });
        DirectionCheck.createLookup("axis", ctx -> {
            LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
            class_2350 direction = lootParams.get(LycheeLootContextParams.DIRECTION);
            class_2680 state = (class_2680)lootParams.get(class_181.field_1224);
            class_2350.class_2351 axis = (class_2350.class_2351)state.method_28500((class_2769)class_2741.field_12496).or(() -> state.method_28500((class_2769)class_2741.field_12529)).orElseThrow();
            return axis.method_10176(direction);
        });
    }

    public static class Type
    implements ContextualConditionType<DirectionCheck> {
        public static final MapCodec<DirectionCheck> CODEC = Codec.stringResolver($ -> $.name, LOOKUPS::get).fieldOf("direction");

        @Override
        public MapCodec<DirectionCheck> method_53736() {
            return CODEC;
        }
    }
}

