/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4550;
import net.minecraft.class_4551;
import net.minecraft.class_4552;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.RegistryEntryDisplay;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionDisplay;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Location(class_205 check) implements ContextualCondition
{
    public static final ImmutableList<Rule<?>> RULES = Location.bootstrapRules();

    private static ImmutableList<Rule<?>> bootstrapRules() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new PosRule("x", it -> it.comp_1794().map(class_2090.class_8747::comp_1802), class_243::method_10216));
        builder.add((Object)new PosRule("y", it -> it.comp_1794().map(class_2090.class_8747::comp_1803), class_243::method_10214));
        builder.add((Object)new PosRule("z", it -> it.comp_1794().map(class_2090.class_8747::comp_1804), class_243::method_10215));
        builder.add((Object)new DimensionRule());
        builder.add((Object)new FeatureRule());
        builder.add((Object)new BiomeRule());
        builder.add((Object)new BlockRule());
        builder.add((Object)new FluidRule());
        builder.add((Object)new LightRule());
        builder.add((Object)new SmokeyRule());
        builder.add((Object)new CanSeeSkyRule());
        return builder.build();
    }

    public ContextualConditionType<Location> type() {
        return ContextualConditionType.LOCATION;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        class_1937 level = ctx.level();
        LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
        if (level.field_9236) {
            return this.testClient(level, lootParams.get(LycheeLootContextParams.BLOCK_POS), (class_243)lootParams.get(class_181.field_24424)).get() ? times : 0;
        }
        return this.check.method_881(lootParams.asLootContext()) ? times : 0;
    }

    @Override
    public TriState testForTooltips(class_1937 level, @Nullable class_1657 player) {
        if (player == null) {
            return TriState.DEFAULT;
        }
        if (!class_2338.field_10980.equals((Object)this.check.comp_1875())) {
            return TriState.DEFAULT;
        }
        class_243 vec = player.method_19538();
        class_2338 pos = player.method_24515();
        return this.testClient(level, pos, vec);
    }

    public TriState testClient(class_1937 level, class_2338 pos, class_243 vec) {
        if (this.check.comp_1874().isEmpty()) {
            return TriState.TRUE;
        }
        class_2338 offset = this.check.comp_1875();
        if (!class_2338.field_10980.equals((Object)offset)) {
            pos = pos.method_10069(offset.method_10263(), offset.method_10264(), offset.method_10260());
        }
        class_2090 predicate = (class_2090)this.check.comp_1874().get();
        TriState finalResult = TriState.TRUE;
        for (Rule rule : RULES) {
            if (rule.isEmpty(predicate)) continue;
            TriState result = rule.testClient(rule.cast(predicate), level, pos, vec);
            if (result == TriState.FALSE) {
                return result;
            }
            if (result != TriState.DEFAULT) continue;
            finalResult = TriState.DEFAULT;
        }
        return finalResult;
    }

    @Override
    public void appendToTooltips(List<class_2561> tooltips, class_1937 level, @Nullable class_1657 player, int indent, boolean inverted) {
        TriState result;
        if (this.check.comp_1874().isEmpty()) {
            return;
        }
        class_2090 predicate = (class_2090)this.check.comp_1874().get();
        boolean test = false;
        class_243 vec = null;
        class_2338 pos = null;
        String key = this.getDescriptionId(inverted);
        boolean noOffset = class_2338.field_10980.equals((Object)this.check.comp_1875());
        if (!noOffset) {
            class_2338 offset = this.check.comp_1875();
            class_5250 content = class_2561.method_43469((String)key, (Object[])new Object[]{offset.method_10263(), offset.method_10264(), offset.method_10260()}).method_27692(class_124.field_1080);
            result = this.testForTooltips(level, player);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, content);
            ++indent;
        }
        if (noOffset && player != null) {
            test = true;
            vec = player.method_19538();
            pos = player.method_24515();
        }
        for (Rule rule : RULES) {
            if (rule.isEmpty(predicate)) continue;
            result = TriState.DEFAULT;
            if (test) {
                result = rule.testClient(rule.cast(predicate), level, pos, vec);
            }
            rule.appendToTooltips(tooltips, indent, key, rule.cast(predicate), result);
        }
    }

    @Override
    public int showingCount() {
        int c = 0;
        if (this.check.comp_1874().isEmpty()) {
            return c;
        }
        class_2090 predicate = (class_2090)this.check.comp_1874().get();
        for (Rule rule : RULES) {
            if (rule.isEmpty(predicate)) continue;
            ++c;
        }
        return c;
    }

    private static class PosRule
    extends Rule<class_2096.class_2099> {
        private final Function<class_243, Double> valueGetter;

        private PosRule(String name, Function<class_2090, Optional<class_2096.class_2099>> boundsGetter, Function<class_243, Double> valueGetter) {
            super(name, boundsGetter);
            this.valueGetter = valueGetter;
        }

        @Override
        public boolean isEmpty(class_2090 predicate) {
            return super.isEmpty(predicate) || ((class_2096.class_2099)((Optional)this.getter.apply(predicate)).orElseThrow()).method_9041();
        }

        @Override
        public TriState testClient(class_2096.class_2099 value, class_1937 level, class_2338 pos, class_243 vec) {
            return TriState.of((boolean)value.method_9047(this.valueGetter.apply(vec).doubleValue()));
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, class_2096.class_2099 value, TriState result) {
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.name), (Object[])new Object[]{BoundsExtensions.getDescription(value)}));
        }
    }

    private static class DimensionRule
    extends Rule<class_5321<class_1937>> {
        private DimensionRule() {
            super("dimension", class_2090::comp_1797);
        }

        @Override
        public TriState testClient(class_5321<class_1937> value, class_1937 level, class_2338 pos, class_243 vec) {
            return TriState.of((value == level.method_27983() ? 1 : 0) != 0);
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, class_5321<class_1937> value, TriState result) {
            class_5250 displayName = RegistryEntryDisplay.of(value, class_7924.field_41223).method_27692(class_124.field_1068);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class FeatureRule
    extends Rule<class_6885<class_3195>> {
        private FeatureRule() {
            super("feature", class_2090::comp_2376);
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, class_6885<class_3195> value, TriState result) {
            class_5250 displayName = RegistryEntryDisplay.of(value, class_7924.field_41246).method_27692(class_124.field_1068);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class BiomeRule
    extends Rule<class_6885<class_1959>> {
        private BiomeRule() {
            super("biome", class_2090::comp_2375);
        }

        @Override
        public TriState testClient(class_6885<class_1959> value, class_1937 level, class_2338 pos, class_243 vec) {
            return TriState.of((boolean)value.method_40241(level.method_23753(pos)));
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, class_6885<class_1959> value, TriState result) {
            class_5250 displayName = RegistryEntryDisplay.of(value, class_7924.field_41236).method_27692(class_124.field_1068);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class BlockRule
    extends Rule<class_4550> {
        private BlockRule() {
            super("block", class_2090::comp_1800);
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, class_4550 value, TriState result) {
            class_2248 block = CommonProxy.getCycledItem(List.copyOf(BlockPredicateExtensions.matchedBlocks(value)), class_2246.field_10124, 1000);
            class_5250 displayName = block.method_9518().method_27692(class_124.field_1068);
            if (value.comp_1733().isPresent() || value.comp_1734().isPresent()) {
                displayName.method_27693("*");
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }

        @Override
        public TriState testClient(class_4550 value, class_1937 level, class_2338 pos, class_243 vec) {
            return TriState.of((boolean)BlockPredicateExtensions.unsafeMatches(level, value, level.method_8320(pos), () -> level.method_8321(pos)));
        }
    }

    private static class FluidRule
    extends Rule<class_4551> {
        private FluidRule() {
            super("fluid", class_2090::comp_1801);
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, class_4551 value, TriState result) {
            List fluids = value.comp_2372().map($ -> $.method_40239().map(class_6880::comp_349).toList()).orElse(List.of());
            class_3611 fluid = CommonProxy.getCycledItem(fluids, class_3612.field_15906, 1000);
            class_5250 displayName = ClientProxy.getFluidName(fluid).method_27661().method_27692(class_124.field_1068);
            if (value.comp_1782().isPresent()) {
                displayName.method_27693("*");
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class LightRule
    extends Rule<class_4552> {
        private LightRule() {
            super("light", class_2090::comp_1799);
        }

        @Override
        public TriState testClient(class_4552 value, class_1937 level, class_2338 pos, class_243 vec) {
            int brightness = level.method_22339(pos);
            return TriState.of((boolean)value.comp_1791().method_9054(brightness));
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, class_4552 value, TriState result) {
            class_5250 displayName = BoundsExtensions.getDescription(value.comp_1791());
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class SmokeyRule
    extends Rule<Boolean> {
        private SmokeyRule() {
            super("smokey", class_2090::comp_1798);
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, Boolean value, TriState result) {
            key = (String)key + "." + this.name;
            if (!value.booleanValue()) {
                key = (String)key + ".not";
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43471((String)key));
        }
    }

    private static class CanSeeSkyRule
    extends Rule<Boolean> {
        private CanSeeSkyRule() {
            super("can_see_sky", class_2090::comp_2771);
        }

        @Override
        public void appendToTooltips(List<class_2561> tooltips, int indent, String key, Boolean value, TriState result) {
            key = (String)key + "." + this.name;
            if (!value.booleanValue()) {
                key = (String)key + ".not";
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, class_2561.method_43471((String)key));
        }
    }

    public static abstract class Rule<T> {
        public final String name;
        protected final Function<class_2090, Optional<T>> getter;

        protected Rule(String name, Function<class_2090, Optional<T>> getter) {
            this.name = name;
            this.getter = getter;
        }

        public boolean isEmpty(class_2090 predicate) {
            return this.getter.apply(predicate).isEmpty();
        }

        public final <Any> Any cast(class_2090 predicate) {
            return (Any)this.getter.apply(predicate).orElseThrow();
        }

        public TriState testClient(T value, class_1937 level, class_2338 pos, class_243 vec) {
            return TriState.DEFAULT;
        }

        public abstract void appendToTooltips(List<class_2561> var1, int var2, String var3, T var4, TriState var5);
    }

    public static class Type
    implements ContextualConditionType<Location> {
        private static final MapCodec<class_205> LOCATION_CHECK_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2090.field_45760.optionalFieldOf("predicate").forGetter(class_205::comp_1874), (App)LycheeCodecs.OFFSET.forGetter(class_205::comp_1875)).apply((Applicative)instance, class_205::new));
        public static final MapCodec<Location> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LOCATION_CHECK_CODEC.forGetter(Location::check)).apply((Applicative)instance, Location::new));

        @Override
        public MapCodec<Location> method_53736() {
            return CODEC;
        }
    }
}

