/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.contextual.Contextual;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.contextual.ContextualHolder;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Or(ContextualHolder conditions) implements ContextualCondition,
Contextual
{
    public ContextualConditionType<Or> type() {
        return ContextualConditionType.OR;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        for (ContextualCondition condition : this.conditions) {
            int result = condition.test(recipe, ctx, times);
            if (result <= 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public TriState testForTooltips(class_1937 level, @Nullable class_1657 player) {
        boolean allFailed = true;
        for (ContextualCondition condition : this.conditions) {
            TriState result = condition.testForTooltips(level, player);
            if (result == TriState.TRUE) {
                return result;
            }
            if (result == TriState.FALSE) continue;
            allFailed = false;
        }
        return allFailed ? TriState.FALSE : TriState.DEFAULT;
    }

    @Override
    public void appendToTooltips(List<class_2561> tooltips, class_1937 level, @Nullable class_1657 player, int indent, boolean inverted) {
        ContextualCondition.super.appendToTooltips(tooltips, level, player, indent, inverted);
        for (ContextualCondition condition : this.conditions) {
            condition.appendToTooltips(tooltips, level, player, indent + 1, false);
        }
    }

    @Override
    public int showingCount() {
        return this.conditions.showingCount();
    }

    public static class Type
    implements ContextualConditionType<Or> {
        public static final MapCodec<Or> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ContextualHolder.CODEC.fieldOf("contextual").forGetter(Or::conditions)).apply((Applicative)instance, Or::new));
        public static final class_9139<class_9129, Or> STREAM_CODEC = ContextualHolder.STREAM_CODEC.method_56432(Or::new, Or::conditions);

        @Override
        public MapCodec<Or> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, Or> method_56104() {
            return STREAM_CODEC;
        }
    }
}

