/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mojang.datafixers.util.Function3;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2096;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_4550;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_8779;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.datagen.ContextualBuilder;
import snownee.lychee.datagen.LycheeBuilder;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.recipes.BlockExplodingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.recipes.DripstoneRecipe;
import snownee.lychee.recipes.ItemBurningRecipe;
import snownee.lychee.recipes.ItemInsideRecipe;
import snownee.lychee.recipes.RandomBlockTickingRecipe;
import snownee.lychee.recipes.ShapedCraftingRecipe;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionLike;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;

public abstract class LycheeRecipeBuilder<T extends LycheeRecipeBuilder<T, R>, R extends ILycheeRecipe<?>>
extends ContextualBuilder<T>
implements LycheeBuilder {
    protected final List<PostAction> postActions = Lists.newArrayListWithExpectedSize((int)6);
    protected boolean hideInRecipeViewer;
    protected boolean ghost;
    @Nullable
    protected String comment;
    protected String group = "default";
    protected class_2096.class_2100 maxRepeats = class_2096.class_2100.field_9708;
    @Nullable
    protected class_8779 advancement;

    public LycheeRecipeCommonProperties properties() {
        return new LycheeRecipeCommonProperties(this.hideInRecipeViewer, this.ghost, Optional.ofNullable(this.comment), this.group, this.contextualHolder(), this.postActions, this.maxRepeats);
    }

    @Contract(value="-> this")
    public T hideInViewer() {
        this.hideInRecipeViewer = true;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="-> this")
    public T ghost() {
        this.ghost = true;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T comment(@Nullable String comment) {
        this.comment = comment;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T group(String group) {
        this.group = group;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T post(PostActionLike postAction) {
        this.postActions.add(postAction.asAction());
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @HideFromJS
    @Contract(value="_ -> this")
    public T post(Collection<? extends PostActionLike> postActions) {
        postActions.forEach(this::post);
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="_ -> this")
    public T maxRepeats(class_2096.class_2100 maxRepeats) {
        this.maxRepeats = maxRepeats;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    @Contract(value="-> this")
    @CanIgnoreReturnValue
    public T noRepeat() {
        return this.maxRepeats(BoundsExtensions.ONE);
    }

    @Contract(value="_ -> this")
    public T advancement(class_8779 advancement) {
        this.advancement = advancement;
        return (T)((LycheeRecipeBuilder)this.self());
    }

    public abstract R build();

    @CanIgnoreReturnValue
    public R export(class_2960 id, class_8790 exporter) {
        R recipe = this.build();
        exporter.method_53819(id, recipe, this.advancement);
        return recipe;
    }

    public static class ShapedCrafting
    extends LycheeRecipeBuilder<ShapedCrafting, ShapedCraftingRecipe> {
        protected final List<PostAction> assemblingActions = Lists.newArrayListWithExpectedSize((int)6);
        private final class_7800 category;
        private final class_1799 result;
        private final List<String> rows = Lists.newArrayList();
        private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
        private boolean showNotification = true;

        public ShapedCrafting(class_7800 category, class_1935 result, int amount) {
            this(category, new class_1799(result, amount));
        }

        public ShapedCrafting(class_7800 category, class_1799 result) {
            this.category = category;
            this.result = result;
        }

        static class_7710 determineBookCategory(class_7800 category) {
            return switch (category) {
                case class_7800.field_40634 -> class_7710.field_40248;
                case class_7800.field_40638, class_7800.field_40639 -> class_7710.field_40250;
                case class_7800.field_40636 -> class_7710.field_40249;
                default -> class_7710.field_40251;
            };
        }

        public ShapedCrafting define(Character key, class_6862<class_1792> tagKey) {
            return this.define(key, class_1856.method_8106(tagKey));
        }

        public ShapedCrafting define(Character key, class_1935 item) {
            return this.define(key, class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }

        public ShapedCrafting define(Character key, class_1856 ingredient) {
            if (this.key.containsKey(key)) {
                throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
            }
            if (key.charValue() == ' ') {
                throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
            }
            this.key.put(key, ingredient);
            return this;
        }

        public ShapedCrafting pattern(String row) {
            if (!this.rows.isEmpty() && row.length() != this.rows.get(0).length()) {
                throw new IllegalArgumentException("Pattern must be the same width on every line!");
            }
            this.rows.add(row);
            return this;
        }

        public ShapedCrafting showNotification(boolean showNotification) {
            this.showNotification = showNotification;
            return this;
        }

        @Contract(value="_ -> this")
        public ShapedCrafting assembling(PostActionLike assemblingAction) {
            this.assemblingActions.add(assemblingAction.asAction());
            return (ShapedCrafting)this.self();
        }

        @HideFromJS
        @Contract(value="_ -> this")
        public ShapedCrafting assembling(Collection<? extends PostActionLike> assemblingActions) {
            assemblingActions.forEach(this::assembling);
            return (ShapedCrafting)this.self();
        }

        @Override
        public ShapedCraftingRecipe build() {
            LycheeRecipeCommonProperties properties = this.properties();
            class_1869 shapedRecipe = new class_1869("default".equals(properties.group()) ? "" : properties.group(), ShapedCrafting.determineBookCategory(this.category), class_8957.method_55085(this.key, this.rows), this.result, this.showNotification);
            return new ShapedCraftingRecipe(properties, shapedRecipe, this.assemblingActions);
        }
    }

    public static class BlockInteracting<R extends BlockInteractingRecipe>
    extends LycheeRecipeBuilder<BlockInteracting<R>, R> {
        protected final Function3<LycheeRecipeCommonProperties, List<SizedIngredient>, class_4550, R> constructor;
        protected final List<SizedIngredient> input;
        protected final class_4550 blockPredicate;

        public BlockInteracting(Function3<LycheeRecipeCommonProperties, List<SizedIngredient>, class_4550, R> constructor, SizedIngredient mainHand, @Nullable SizedIngredient offHand, class_4550 block) {
            this.constructor = constructor;
            this.input = offHand == null ? List.of(mainHand) : List.of(mainHand, offHand);
            this.blockPredicate = block;
            this.noRepeat();
        }

        @Override
        public R build() {
            return (R)((BlockInteractingRecipe)this.constructor.apply((Object)this.properties(), this.input, (Object)this.blockPredicate));
        }
    }

    public static class ItemBurning
    extends LycheeRecipeBuilder<ItemBurning, ItemBurningRecipe> {
        protected final SizedIngredient input;

        public ItemBurning(SizedIngredient input) {
            this.input = input;
        }

        @Override
        public ItemBurningRecipe build() {
            return new ItemBurningRecipe(this.properties(), this.input);
        }
    }

    public static class RandomBlockTicking
    extends LycheeRecipeBuilder<RandomBlockTicking, RandomBlockTickingRecipe> {
        protected final class_4550 block;

        public RandomBlockTicking(class_4550 block) {
            this.block = block;
        }

        @Override
        public RandomBlockTickingRecipe build() {
            return new RandomBlockTickingRecipe(this.properties(), this.block);
        }
    }

    public static class BlockExploding
    extends LycheeRecipeBuilder<BlockExploding, BlockExplodingRecipe> {
        protected final class_4550 block;

        public BlockExploding(class_4550 block) {
            this.block = block;
        }

        @Override
        public BlockExplodingRecipe build() {
            return new BlockExplodingRecipe(this.properties(), this.block);
        }
    }

    public static class AnvilCrafting
    extends LycheeRecipeBuilder<AnvilCrafting, AnvilCraftingRecipe> {
        protected final class_2371<class_1856> ingredients;
        protected final int levelCost;
        protected final int materialCost;
        protected final class_1799 output;
        protected final List<PostAction> assemblingActions = Lists.newArrayListWithExpectedSize((int)6);

        public AnvilCrafting(class_1856 left, @Nullable class_1856 right, int materialCost, int levelCost, class_1799 output) {
            this.ingredients = right == null ? class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{left}) : class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{left, right});
            this.levelCost = levelCost;
            this.materialCost = materialCost;
            this.output = output;
        }

        @Contract(value="_ -> this")
        public AnvilCrafting assembling(PostActionLike assemblingAction) {
            this.assemblingActions.add(assemblingAction.asAction());
            return (AnvilCrafting)this.self();
        }

        @HideFromJS
        @Contract(value="_ -> this")
        public AnvilCrafting assembling(Collection<? extends PostActionLike> assemblingActions) {
            assemblingActions.forEach(this::assembling);
            return (AnvilCrafting)this.self();
        }

        @Override
        public AnvilCraftingRecipe build() {
            return new AnvilCraftingRecipe(this.properties(), this.ingredients, this.output, this.assemblingActions, this.levelCost, this.materialCost);
        }
    }

    public static class Dripstone
    extends LycheeRecipeBuilder<Dripstone, DripstoneRecipe> {
        protected final class_4550 sourceBlock;
        protected final class_4550 targetBlock;

        public Dripstone(class_4550 sourceBlock, class_4550 targetBlock) {
            this.sourceBlock = sourceBlock;
            this.targetBlock = targetBlock;
        }

        @Override
        public DripstoneRecipe build() {
            return new DripstoneRecipe(this.properties(), this.sourceBlock, this.targetBlock);
        }
    }

    public static class ItemInside
    extends Shapeless<ItemInside, ItemInsideRecipe> {
        protected class_4550 block = BlockPredicateExtensions.ANY;
        protected int time;

        @Contract(value="_ -> this")
        public ItemInside blockIn(Object block) {
            this.block = this.block(block);
            return (ItemInside)this.self();
        }

        @Contract(value="_ -> this")
        public ItemInside time(int time) {
            this.time = time;
            return (ItemInside)this.self();
        }

        @Override
        public ItemInsideRecipe build() {
            return new ItemInsideRecipe(this.properties(), this.block, this.time, this.ingredientCollection());
        }
    }

    public static class BlockCrushing
    extends Shapeless<BlockCrushing, BlockCrushingRecipe> {
        protected class_4550 fallingBlock = BlockCrushingRecipe.ANVIL;
        protected class_4550 landingBlock = BlockPredicateExtensions.ANY;

        @Contract(value="_ -> this")
        public BlockCrushing fallingBlock(Object fallingBlock) {
            this.fallingBlock = this.block(fallingBlock);
            return (BlockCrushing)this.self();
        }

        @Contract(value="_ -> this")
        public BlockCrushing landingBlock(Object landingBlock) {
            this.landingBlock = this.block(landingBlock);
            return (BlockCrushing)this.self();
        }

        @Override
        public BlockCrushingRecipe build() {
            return new BlockCrushingRecipe(this.properties(), this.fallingBlock, this.landingBlock, this.ingredientCollection());
        }
    }

    public static class SimpleShapeless<R extends ILycheeRecipe<?>>
    extends Shapeless<SimpleShapeless<R>, R> {
        protected final BiFunction<LycheeRecipeCommonProperties, IngredientCollection, R> constructor;

        public SimpleShapeless(BiFunction<LycheeRecipeCommonProperties, IngredientCollection, R> constructor) {
            this.constructor = constructor;
        }

        @Override
        public R build() {
            return (R)((ILycheeRecipe)this.constructor.apply(this.properties(), this.ingredientCollection()));
        }
    }

    public static abstract class Shapeless<T extends LycheeRecipeBuilder<T, R>, R extends ILycheeRecipe<?>>
    extends LycheeRecipeBuilder<T, R> {
        protected final List<SizedIngredient> ingredients = Lists.newArrayList();

        @Contract(value="_ -> this")
        public T itemIn(Collection<SizedIngredient> ingredients) {
            this.ingredients.addAll(ingredients);
            return (T)((LycheeRecipeBuilder)this.self());
        }

        protected IngredientCollection ingredientCollection() {
            return IngredientCollection.of(this.ingredients);
        }
    }
}

