/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.kiwi.util.resource.OneTimeLoader;
import snownee.lychee.LycheeConfig;
import snownee.lychee.util.json.JsonFragmentManager;

@Mixin(value={class_1863.class}, priority=333)
public class RecipeManagerMixin {
    @Unique
    private static final ThreadLocal<JsonFragmentManager> fragmentManagerProvider = new ThreadLocal();

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void lychee_beginApply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        if (LycheeConfig.enableYamlRecipes) {
            Map yamlRecipes = OneTimeLoader.load((class_3300)resourceManager, (String)class_7924.method_60915((class_5321)class_7924.field_52178), (Codec)class_5699.field_40721);
            for (Map.Entry entry : yamlRecipes.entrySet()) {
                object.putIfAbsent((class_2960)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        if (LycheeConfig.enableFragment) {
            JsonFragmentManager fragmentManager = new JsonFragmentManager(resourceManager);
            fragmentManagerProvider.set(fragmentManager);
            object.values().forEach(fragmentManager::process);
        }
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="RETURN")})
    private void lychee_endApply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        if (LycheeConfig.enableFragment) {
            fragmentManagerProvider.remove();
        }
    }

    @Inject(method={"fromJson"}, at={@At(value="HEAD")})
    private static void lychee_fromJson(class_2960 resourceLocation, JsonObject json, class_7225.class_7874 provider, CallbackInfoReturnable<class_8786<?>> cir) {
        JsonFragmentManager fragmentManager;
        if (LycheeConfig.enableFragment && json != null && (fragmentManager = fragmentManagerProvider.get()) != null) {
            fragmentManager.process((JsonElement)json);
        }
    }
}

