/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.AnvilContext;
import snownee.lychee.util.NonNullListExtensions;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class AnvilCraftingRecipe
extends LycheeRecipe<LycheeContext> {
    protected final class_2371<class_1856> ingredients;
    protected final int levelCost;
    protected final int materialCost;
    protected final class_1799 output;
    protected final List<PostAction> assemblingActions;

    public AnvilCraftingRecipe(LycheeRecipeCommonProperties commonProperties, class_2371<class_1856> ingredients, class_1799 output, List<PostAction> assemblingActions, int levelCost, int materialCost) {
        super(commonProperties);
        this.ingredients = ingredients;
        this.levelCost = levelCost;
        this.materialCost = materialCost;
        this.output = output;
        this.assemblingActions = assemblingActions;
        this.onConstructed();
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        if (pointer.size() == 1) {
            if (pointer.getString(0).equals("item_out")) {
                return IntList.of((int)2);
            }
            if (pointer.getString(0).equals("item_in")) {
                return this.ingredients.size() == 1 ? IntList.of((int)0) : IntList.of((int)0, (int)1);
            }
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("item_in")) {
            try {
                int i = pointer.getInt(1);
                if (i >= 0 && i < 2) {
                    return IntList.of((int)i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IntList.of();
    }

    public boolean matches(LycheeContext context, class_1937 level) {
        AnvilContext anvilContext = context.get(LycheeContextKey.ANVIL);
        if (this.ingredients.size() == 2 && ((class_1799)anvilContext.input().getSecond()).method_7947() < this.materialCost) {
            return false;
        }
        return ((class_1856)this.ingredients.getFirst()).method_8093((class_1799)anvilContext.input().getFirst()) && ((class_1856)this.ingredients.getLast()).method_8093((class_1799)anvilContext.input().getSecond());
    }

    public class_1799 assemble(LycheeContext context, class_7225.class_7874 provider) {
        AnvilContext anvilContext = context.get(LycheeContextKey.ANVIL);
        anvilContext.setLevelCost(this.levelCost);
        anvilContext.setMaterialCost(this.materialCost);
        context.get(LycheeContextKey.ITEM).replace(2, this.method_8110(provider));
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        actionContext.reset();
        actionContext.jobs.addAll(this.assemblingActions.stream().map(it -> new Job((PostAction)it, 1)).toList());
        actionContext.run(context);
        return context.method_59984(2);
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.output.method_7972();
    }

    @Override
    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    @Override
    public LycheeRecipeSerializer<AnvilCraftingRecipe> getSerializer() {
        return RecipeSerializers.ANVIL_CRAFTING;
    }

    @Override
    public LycheeRecipeType<AnvilCraftingRecipe> getType() {
        return RecipeTypes.ANVIL_CRAFTING;
    }

    @Override
    public Stream<PostAction> allActions() {
        return Streams.concat((Stream[])new Stream[]{this.postActions().stream(), this.assemblingActions().stream()});
    }

    public int levelCost() {
        return this.levelCost;
    }

    public int materialCost() {
        return this.materialCost;
    }

    public class_1799 output() {
        return this.output;
    }

    public List<PostAction> assemblingActions() {
        return this.assemblingActions;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<AnvilCraftingRecipe> {
        public static final MapCodec<AnvilCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(ILycheeRecipe::commonProperties), (App)LycheeCodecs.sizeLimit(KCodecs.compactList(LycheeCodecs.NONEMPTY_INGREDIENT), 1, 2).xmap(NonNullListExtensions::copyOf, Function.identity()).fieldOf("item_in").forGetter(AnvilCraftingRecipe::method_8117), (App)LycheeCodecs.ITEM_STACK.fieldOf("item_out").forGetter(AnvilCraftingRecipe::output), (App)PostAction.LIST_CODEC.optionalFieldOf("assembling", List.of()).forGetter(AnvilCraftingRecipe::assemblingActions), (App)class_5699.field_33442.optionalFieldOf("level_cost", (Object)1).forGetter(AnvilCraftingRecipe::levelCost), (App)class_5699.field_33441.optionalFieldOf("material_cost", (Object)1).forGetter(AnvilCraftingRecipe::materialCost)).apply((Applicative)instance, AnvilCraftingRecipe::new));
        public static final class_9139<class_9129, AnvilCraftingRecipe> STREAM_CODEC = class_9139.method_58025(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (class_9139)class_1856.field_48355.method_56433(class_9135.method_58000((int)2)).method_56432(NonNullListExtensions::copyOf, Function.identity()), AnvilCraftingRecipe::method_8117, (class_9139)class_1799.field_48349, AnvilCraftingRecipe::output, PostAction.STREAM_LIST_CODEC, AnvilCraftingRecipe::assemblingActions, (class_9139)class_9135.field_48550, AnvilCraftingRecipe::levelCost, (class_9139)class_9135.field_48550, AnvilCraftingRecipe::materialCost, AnvilCraftingRecipe::new);

        @Override
        public MapCodec<AnvilCraftingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, AnvilCraftingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

