/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2105;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_6885;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.BlockCrushingRecipeType;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.RecipeMatcher;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ItemShapelessRecipeUtils;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class BlockCrushingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe {
    public static final class_4550 ANVIL = class_4550.class_4710.method_23880().method_29233(class_3481.field_15486).method_23882();
    protected class_4550 fallingBlock;
    protected class_4550 landingBlock;
    protected IngredientCollection ingredients;

    public BlockCrushingRecipe(LycheeRecipeCommonProperties commonProperties, class_4550 fallingBlock, class_4550 landingBlock, IngredientCollection ingredients) {
        super(commonProperties);
        this.fallingBlock = fallingBlock;
        this.landingBlock = landingBlock;
        this.ingredients = ingredients;
        this.onConstructed();
    }

    @Override
    public class_4550 blockPredicate() {
        return this.fallingBlock;
    }

    public class_4550 landingBlock() {
        return this.landingBlock;
    }

    public boolean matches(LycheeContext context, class_1937 level) {
        ItemShapelessContext itemShapelessContext = context.get(LycheeContextKey.ITEM_SHAPELESS);
        if (itemShapelessContext.totalItems < this.ingredients.ingredientCount()) {
            return false;
        }
        if (!BlockPredicateExtensions.isAny(this.landingBlock) && !BlockPredicateExtensions.matches(this.landingBlock, context)) {
            return false;
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        class_1540 entity = (class_1540)lootParams.get(class_181.field_1226);
        if (!this.matchesFallingBlock(entity.method_6962(), entity.field_7194)) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return true;
        }
        List<class_1542> itemEntities = itemShapelessContext.itemEntities.stream().filter($ -> this.ingredients.anyMatch($.method_6983())).limit(27L).toList();
        List<class_1799> items = itemEntities.stream().map(class_1542::method_6983).toList();
        int[] amount = items.stream().mapToInt(class_1799::method_7947).toArray();
        Optional<RecipeMatcher<class_1799>> match = RecipeMatcher.findMatches(items, this.ingredients.flattenedIngredients(), amount);
        if (match.isEmpty()) {
            return false;
        }
        itemShapelessContext.filteredItems = itemEntities;
        itemShapelessContext.setMatcher(match.get());
        return true;
    }

    public boolean matchesFallingBlock(class_2680 blockstate, @Nullable class_2487 nbt) {
        if (BlockPredicateExtensions.isAny(this.blockPredicate())) {
            return true;
        }
        if (this.blockPredicate().comp_1732().isPresent() && !blockstate.method_40143((class_6885)this.blockPredicate().comp_1732().get())) {
            return false;
        }
        if (this.blockPredicate().comp_1733().isPresent() && !((class_4559)this.blockPredicate().comp_1733().get()).method_22514(blockstate)) {
            return false;
        }
        if (this.blockPredicate().comp_1734().isEmpty()) {
            return true;
        }
        return nbt != null && ((class_2105)this.blockPredicate().comp_1734().get()).method_9077((class_2520)nbt);
    }

    @Override
    public IngredientCollection ingredientCollection() {
        return this.ingredients;
    }

    @Override
    public List<class_4550> getBlockInputs() {
        return (List)class_156.method_654((Object)Lists.newArrayList((Object[])new class_4550[]{this.fallingBlock}), it -> {
            if (!BlockPredicateExtensions.isAny(this.landingBlock)) {
                it.add(this.landingBlock);
            }
        });
    }

    @Override
    public LycheeRecipeSerializer<BlockCrushingRecipe> getSerializer() {
        return RecipeSerializers.BLOCK_CRUSHING;
    }

    public BlockCrushingRecipeType getType() {
        return RecipeTypes.BLOCK_CRUSHING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<BlockCrushingRecipe> {
        public static final MapCodec<BlockCrushingRecipe> CODEC = ItemShapelessRecipeUtils.validatedCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("falling_block", (Object)ANVIL).forGetter(it -> it.fallingBlock), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("landing_block", (Object)BlockPredicateExtensions.ANY).forGetter(BlockCrushingRecipe::landingBlock), (App)IngredientCollection.CODEC.optionalFieldOf("item_in", (Object)IngredientCollection.EMPTY).forGetter(BlockCrushingRecipe::ingredientCollection)).apply((Applicative)instance, BlockCrushingRecipe::new)));
        public static final class_9139<class_9129, BlockCrushingRecipe> STREAM_CODEC = class_9139.method_56905(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (class_9139)class_4550.field_49181, it -> it.fallingBlock, (class_9139)class_4550.field_49181, BlockCrushingRecipe::landingBlock, IngredientCollection.STREAM_CODEC, BlockCrushingRecipe::ingredientCollection, BlockCrushingRecipe::new);

        @Override
        public MapCodec<BlockCrushingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, BlockCrushingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

