/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_8786;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeTags;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.network.SCustomLevelEventPacket;
import snownee.lychee.recipes.BlockCrushingRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.LycheeFallingBlockEntity;
import snownee.lychee.util.RecipeMatcher;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;
import snownee.lychee.util.recipe.ValidItemCache;

public class BlockCrushingRecipeType
extends BlockKeyableRecipeType<BlockCrushingRecipe> {
    private final ValidItemCache validItems = new ValidItemCache();

    public BlockCrushingRecipeType(String name, Class<BlockCrushingRecipe> clazz, @Nullable class_176 paramSet) {
        super(name, clazz, paramSet);
    }

    public void process(class_1540 entity) {
        boolean matched;
        if (this.isEmpty()) {
            return;
        }
        class_2338 pos = CommonProxy.getOnPos((class_1297)entity);
        class_2680 fallingBlock = entity.method_6962();
        List recipes = this.recipesByBlock.getOrDefault(fallingBlock.method_26204(), Collections.emptyList());
        if (recipes.isEmpty()) {
            return;
        }
        class_238 box = entity.method_5829();
        class_1937 level = entity.method_37908();
        class_2680 landingBlock = level.method_8320(pos);
        if (landingBlock.method_26164(LycheeTags.EXTEND_BOX)) {
            box = box.method_991(new class_238(pos));
        }
        List itemEntities = entity.method_37908().method_8390(class_1542.class, box, $ -> $.method_5805() && this.validItems.contains($.method_6983()));
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, entity.method_37908());
        ItemShapelessContext itemShapelessContext = new ItemShapelessContext(itemEntities, context);
        context.put(LycheeContextKey.ITEM_SHAPELESS, itemShapelessContext);
        Optional<RecipeMatcher<class_1799>> matcher = itemShapelessContext.getMatcher();
        LootParamsContext lootParams = context.initLootParams(this);
        lootParams.set(class_181.field_24424, entity.method_19538());
        lootParams.set(class_181.field_1226, entity);
        lootParams.set(class_181.field_1224, landingBlock);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, pos);
        lootParams.validate();
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        boolean matchedAny = false;
        int loop = 0;
        block2: do {
            matched = false;
            for (class_8786 recipe : recipes) {
                if (((BlockCrushingRecipe)recipe.comp_1933()).ingredients.isEmpty() && loop > 0) continue;
                try {
                    Optional match = this.tryMatch(recipe, level, context);
                    if (!match.isPresent()) continue;
                    matched = true;
                    matchedAny = true;
                    int times = 1;
                    context.put(recipe);
                    if (matcher.map(it -> it.inputUsed.length > 0).orElse(false).booleanValue()) {
                        int[] inputUsed = matcher.get().inputUsed;
                        times = ((BlockCrushingRecipe)recipe.comp_1933()).getRandomRepeats(Integer.MAX_VALUE, context);
                        for (int i = 0; i < inputUsed.length; ++i) {
                            if (inputUsed[i] <= 0) continue;
                            class_1799 stack = itemShapelessContext.filteredItems.get(i).method_6983();
                            times = Math.min(times, stack.method_7947() / inputUsed[i]);
                        }
                    }
                    ((BlockCrushingRecipe)match.get().comp_1933()).applyPostActions(context, times);
                    if (actionContext.avoidDefault) {
                        ((LycheeFallingBlockEntity)entity).lychee$cancelDrop();
                    }
                    HashSet alreadySentParticles = Sets.newHashSet();
                    ItemStackHolderCollection itemContext = context.get(LycheeContextKey.ITEM);
                    for (ExtendedItemStackHolder holder : itemContext) {
                        ItemStackHolder itemStackHolder;
                        if (holder.getConsumption() <= 0 || holder.get().method_7960() || !((itemStackHolder = holder.holder()) instanceof ItemStackHolder.Entity)) continue;
                        ItemStackHolder.Entity entityHolder = (ItemStackHolder.Entity)itemStackHolder;
                        if (alreadySentParticles.contains(holder)) continue;
                        alreadySentParticles.add(holder);
                        class_243 position = entityHolder.getEntity().method_19538();
                        new SCustomLevelEventPacket(holder.get().method_7972(), position).sendToAround((class_3218)entityHolder.getEntity().method_37908());
                    }
                    itemShapelessContext.totalItems -= itemContext.postApply(true, times);
                    if (((BlockCrushingRecipe)recipe.comp_1933()).maxRepeats().method_9041()) {
                        itemShapelessContext.filteredItems = null;
                        itemShapelessContext.setMatcher(null);
                        itemShapelessContext.itemEntities.removeIf($ -> $.method_6983().method_7960());
                        continue;
                    }
                    break block2;
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("", (Throwable)e);
                    break block2;
                }
            }
        } while (++loop < 100 && matched);
        if (matchedAny) {
            class_2680 state = level.method_8320(entity.method_24515());
            if (!class_2346.method_10128((class_2680)state)) {
                entity.method_23327(entity.method_23317(), (double)(pos.method_10264() + 1), entity.method_23321());
            }
            ((LycheeFallingBlockEntity)entity).lychee$matched();
            itemShapelessContext.itemEntities.forEach($ -> $.method_6979($.method_6983().method_7972()));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        super.refreshCache();
        this.validItems.refreshCache(this.recipes);
    }

    @Override
    public Comparator<class_8786<BlockCrushingRecipe>> comparator() {
        return Comparator.comparing(class_8786::comp_1933, Comparator.comparingInt($ -> $.method_8117().size()).thenComparing($ -> !BlockPredicateExtensions.isAny($.landingBlock())).thenComparing($ -> !$.maxRepeats().method_9041()).thenComparing(class_1860::method_8118).reversed());
    }
}

