/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3965;
import net.minecraft.class_4550;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.NonNullListExtensions;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.BlockKeyableRecipeType;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class BlockInteractingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe {
    private static final Codec<SizedIngredient> OPTIONAL_SIZED_INGREDIENT_CODEC = class_5699.method_57155(LycheeCodecs.SIZED_INGREDIENT).xmap(it -> it.orElse(SizedIngredient.EMPTY), Optional::of);
    protected final List<SizedIngredient> input;
    protected final class_4550 blockPredicate;

    public static class_1269 invoke(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        if (hand == class_1268.field_5810 && player.method_6079().method_7960()) {
            return class_1269.field_5811;
        }
        if (player.method_7357().method_7904(player.method_5998(hand).method_7909())) {
            return class_1269.field_5811;
        }
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.BLOCK_INTERACTING);
        lootParams.set(LycheeLootContextParams.DIRECTION, hitResult.method_17780());
        Optional result = RecipeTypes.BLOCK_INTERACTING.process(player, hand, hitResult.method_17777(), hitResult.method_17784(), context);
        return result.map(it -> {
            player.method_23667(hand, true);
            return class_1269.field_5812;
        }).orElse(class_1269.field_5811);
    }

    public BlockInteractingRecipe(LycheeRecipeCommonProperties commonProperties, List<SizedIngredient> input, class_4550 blockPredicate) {
        super(commonProperties);
        this.input = input;
        this.blockPredicate = blockPredicate;
        this.onConstructed();
    }

    public static <T extends BlockInteractingRecipe> MapCodec<T> codec(Function3<LycheeRecipeCommonProperties, List<SizedIngredient>, class_4550, T> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.mapCodec(BoundsExtensions.ONE).forGetter(LycheeRecipe::commonProperties), (App)LycheeCodecs.sizeLimit(KCodecs.compactList(OPTIONAL_SIZED_INGREDIENT_CODEC), 1, 2).fieldOf("item_in").forGetter(BlockInteractingRecipe::sizedIngredients), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("block_in", (Object)BlockPredicateExtensions.ANY).forGetter(BlockInteractingRecipe::blockPredicate)).apply((Applicative)instance, constructor));
    }

    @Override
    public List<SizedIngredient> sizedIngredients() {
        return this.input;
    }

    @Override
    public class_4550 blockPredicate() {
        return this.blockPredicate;
    }

    public boolean matches(LycheeContext context, class_1937 level) {
        return !(!this.input.getFirst().test(context.method_59984(0)) || !BlockPredicateExtensions.isAny(this.blockPredicate) && !BlockPredicateExtensions.matches(this.blockPredicate, context) || this.input.size() != 1 && !this.input.getLast().test(context.method_59984(1)));
    }

    @Override
    public class_2371<class_1856> method_8117() {
        return NonNullListExtensions.copyOf(this.input.stream().map(SizedIngredient::ingredient).toList());
    }

    @Override
    public LycheeRecipeSerializer<? extends BlockInteractingRecipe> getSerializer() {
        return RecipeSerializers.BLOCK_INTERACTING;
    }

    @Override
    public BlockKeyableRecipeType<? extends BlockInteractingRecipe> getType() {
        return RecipeTypes.BLOCK_INTERACTING;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<BlockInteractingRecipe> {
        public static MapCodec<BlockInteractingRecipe> CODEC = BlockInteractingRecipe.codec(BlockInteractingRecipe::new);
        public static final class_9139<class_9129, BlockInteractingRecipe> STREAM_CODEC = class_9139.method_56436(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (class_9139)SizedIngredient.STREAM_CODEC.method_56433(class_9135.method_58000((int)2)), BlockInteractingRecipe::sizedIngredients, (class_9139)class_4550.field_49181, BlockInteractingRecipe::blockPredicate, BlockInteractingRecipe::new);

        @Override
        public MapCodec<BlockInteractingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, BlockInteractingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

