/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4550;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.action.Delay;
import snownee.lychee.action.Exit;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.contextual.Location;
import snownee.lychee.contextual.Not;
import snownee.lychee.mixin.particles.PointedDripstoneBlockAccess;
import snownee.lychee.mixin.predicates.LocationPredicate$BuilderAccess;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualHolder;
import snownee.lychee.util.particles.dripstone.DripstoneParticleService;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ChanceRecipe;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class DripstoneRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe,
ChanceRecipe {
    protected final class_4550 sourceBlock;
    protected final class_4550 targetBlock;
    private float chance = 1.0f;

    public DripstoneRecipe(LycheeRecipeCommonProperties commonProperties, class_4550 sourceBlock, class_4550 targetBlock) {
        super(commonProperties);
        this.sourceBlock = sourceBlock;
        this.targetBlock = targetBlock;
        this.onConstructed();
    }

    public static boolean invoke(class_2680 blockState, class_3218 level, class_2338 blockPos) {
        if (RecipeTypes.DRIPSTONE_DRIPPING.isEmpty()) {
            return false;
        }
        class_2338 tipPos = PointedDripstoneBlockAccess.callFindTip(blockState, (class_1936)level, blockPos, 11, false);
        if (tipPos == null) {
            return false;
        }
        class_2338 targetPos = DripstoneRecipe.findTargetBelowStalactiteTip((class_1937)level, tipPos);
        if (targetPos == null) {
            return false;
        }
        class_2680 sourceBlock = DripstoneParticleService.findBlockAboveStalactite((class_1937)level, blockPos, blockState);
        if (sourceBlock == null) {
            return false;
        }
        class_2680 targetBlock = level.method_8320(targetPos);
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        context.put(LycheeContextKey.DRIPSTONE_SOURCE, sourceBlock);
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.DRIPSTONE_DRIPPING);
        lootParams.set(class_181.field_1224, targetBlock);
        class_243 origin = new class_243((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.99, (double)targetPos.method_10260() + 0.5);
        lootParams.set(class_181.field_24424, origin);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, targetPos);
        lootParams.validate();
        class_8786 recipe = RecipeTypes.DRIPSTONE_DRIPPING.process((class_1937)level, targetBlock, context);
        if (recipe == null) {
            return false;
        }
        level.method_20290(1504, tipPos, 0);
        int i = tipPos.method_10264() - targetPos.method_10264();
        int j = 50 + i;
        class_2090.class_2091 builder = new class_2090.class_2091();
        ((LocationPredicate$BuilderAccess)builder).setBlock(Optional.of(((DripstoneRecipe)recipe.comp_1933()).targetBlock));
        class_205 check = (class_205)class_205.method_884((class_2090.class_2091)builder).build();
        Exit exit = new Exit(new PostActionCommonProperties(new ContextualHolder(List.of(new Not(new Location(check)))), Optional.empty()));
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        actionContext.jobs.offer(new Job(exit, 1));
        actionContext.jobs.offer(new Job(new Delay((float)j / 20.0f), 1));
        actionContext.run(context);
        return true;
    }

    public boolean matches(LycheeContext context, class_1937 level) {
        if (!BlockPredicateExtensions.matches(this.targetBlock, context)) {
            return false;
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        return BlockPredicateExtensions.unsafeMatches(level, this.sourceBlock, context.get(LycheeContextKey.DRIPSTONE_SOURCE), () -> level.method_8321(lootParams.get(LycheeLootContextParams.BLOCK_POS)));
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    @Override
    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public LycheeRecipeSerializer<DripstoneRecipe> getSerializer() {
        return RecipeSerializers.DRIPSTONE_DRIPPING;
    }

    @Override
    public LycheeRecipeType<DripstoneRecipe> getType() {
        return RecipeTypes.DRIPSTONE_DRIPPING;
    }

    @Override
    public class_4550 blockPredicate() {
        return this.targetBlock;
    }

    public class_4550 sourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public List<class_4550> getBlockInputs() {
        return List.of(this.sourceBlock, this.targetBlock);
    }

    public static boolean safeTick(class_2680 state, class_3218 serverLevel, class_2338 blockPos, class_5819 randomSource) {
        if (!PointedDripstoneBlockAccess.callIsStalactiteStartPos(state, (class_4538)serverLevel, blockPos)) {
            return false;
        }
        float f = randomSource.method_43057();
        if (f > 0.17578125f && f > 0.05859375f) {
            return false;
        }
        return DripstoneRecipe.invoke(state, serverLevel, blockPos);
    }

    @Nullable
    private static class_2338 findTargetBelowStalactiteTip(class_1937 level, class_2338 blockPos2) {
        Predicate<class_2680> predicate = blockState -> !blockState.method_26215() && RecipeTypes.DRIPSTONE_DRIPPING.has((class_2680)blockState);
        BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> PointedDripstoneBlockAccess.callCanDripThrough((class_1922)level, blockPos, blockState);
        return PointedDripstoneBlockAccess.callFindBlockVertical((class_1936)level, blockPos2, class_2350.field_11033.method_10171(), biPredicate, predicate, 11).orElse(null);
    }

    public static class Serializer
    implements LycheeRecipeSerializer<DripstoneRecipe> {
        public static final MapCodec<DripstoneRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.fieldOf("source_block").forGetter(DripstoneRecipe::sourceBlock), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.fieldOf("target_block").forGetter(DripstoneRecipe::blockPredicate)).apply((Applicative)instance, DripstoneRecipe::new));
        public static final class_9139<class_9129, DripstoneRecipe> STREAM_CODEC = class_9139.method_56436(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (class_9139)class_4550.field_49181, DripstoneRecipe::sourceBlock, (class_9139)class_4550.field_49181, DripstoneRecipe::blockPredicate, DripstoneRecipe::new);

        @Override
        public MapCodec<DripstoneRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, DripstoneRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

