/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_176;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.EntityTickingRecipe;
import snownee.lychee.util.LycheeEntity;
import snownee.lychee.util.LycheeEntityType;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class EntityTickingRecipeType
extends LycheeRecipeType<EntityTickingRecipe> {
    private static final Set<LycheeContextKey<?>> PRESERVED_KEYS = Set.of(LycheeContextKey.LEVEL, LycheeContextKey.LOOT_PARAMS);

    public EntityTickingRecipeType(String name, Class<EntityTickingRecipe> clazz, @Nullable class_176 contextParamSet) {
        super(name, clazz, contextParamSet);
    }

    @Override
    public void refreshCache() {
        super.refreshCache();
        ArrayListMultimap map = ArrayListMultimap.create();
        for (class_8786 recipe : this.recipes) {
            ((EntityTickingRecipe)recipe.comp_1933()).predicate().comp_1761().map($ -> $.comp_1775().method_40239()).orElseGet(Stream::empty).forEach(arg_0 -> EntityTickingRecipeType.lambda$refreshCache$1((ListMultimap)map, recipe, arg_0));
        }
        for (class_1299 type : class_7923.field_41177) {
            ((LycheeEntityType)type).lychee$setTickingRecipes((ImmutableList<class_8786<EntityTickingRecipe>>)ImmutableList.copyOf((Collection)map.get((Object)type)));
        }
    }

    public void process(class_1297 entity, List<class_8786<EntityTickingRecipe>> recipes) {
        LootParamsContext lootParams;
        if (recipes.isEmpty() || entity.method_37908().field_9236) {
            return;
        }
        class_3218 level = (class_3218)entity.method_37908();
        LycheeEntity lycheeEntity = (LycheeEntity)entity;
        LycheeContext context = lycheeEntity.lychee$getContext();
        if (context == null) {
            context = new LycheeContext();
            context.put(LycheeContextKey.LEVEL, level);
            lycheeEntity.lychee$setContext(context);
            lootParams = context.initLootParams(this);
        } else {
            lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        }
        lootParams.set(class_181.field_1226, entity);
        lootParams.set(class_181.field_24424, entity.method_19538());
        lootParams.validate();
        for (class_8786<EntityTickingRecipe> recipeHolder : recipes) {
            EntityTickingRecipe recipe = (EntityTickingRecipe)recipeHolder.comp_1933();
            if (recipe.interval() > 1 && (entity.field_6012 + 1) % recipe.interval() != 0 || !recipe.withoutTypePredicate().method_8909(level, entity.method_19538(), entity) || recipe.test(recipe, context, 1) <= 0 || !recipe.matches(context, (class_1937)level)) continue;
            context.put(recipeHolder);
            recipe.applyPostActions(context, 1);
            boolean avoidDefault = context.get(LycheeContextKey.ACTION).avoidDefault;
            context.removeAllExcept(PRESERVED_KEYS);
            if (!avoidDefault) continue;
            break;
        }
    }

    private static /* synthetic */ void lambda$refreshCache$1(ListMultimap map, class_8786 recipe, class_6880 type) {
        map.put((Object)((class_1299)type.comp_349()), (Object)recipe);
    }
}

