/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ItemShapelessRecipeUtils;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class ItemExplodingRecipe
extends LycheeRecipe<LycheeContext>
implements Comparable<ItemExplodingRecipe> {
    protected IngredientCollection ingredients;

    public static void invoke(class_3218 level, double x, double y, double z, List<class_1297> entityList, float radius) {
        Stream<class_1542> itemEntities = entityList.stream().filter(it -> it instanceof class_1542).map(class_1542.class::cast);
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        LootParamsContext lootParams = context.initLootParams(RecipeTypes.ITEM_EXPLODING);
        lootParams.set(class_181.field_24424, new class_243(x, y, z));
        lootParams.set(class_181.field_1225, Float.valueOf(radius));
        RecipeTypes.ITEM_EXPLODING.process(itemEntities, context);
    }

    public ItemExplodingRecipe(LycheeRecipeCommonProperties commonProperties, IngredientCollection ingredients) {
        super(commonProperties);
        this.ingredients = ingredients;
        this.onConstructed();
    }

    public boolean matches(LycheeContext context, class_1937 level) {
        return ItemShapelessRecipeUtils.matches(context, this.ingredients);
    }

    @Override
    public LycheeRecipeSerializer<ItemExplodingRecipe> getSerializer() {
        return RecipeSerializers.ITEM_EXPLODING;
    }

    @Override
    public LycheeRecipeType<ItemExplodingRecipe> getType() {
        return RecipeTypes.ITEM_EXPLODING;
    }

    @Override
    public IngredientCollection ingredientCollection() {
        return this.ingredients;
    }

    @Override
    public int compareTo(ItemExplodingRecipe that) {
        int i = Integer.compare(this.maxRepeats().method_9041() ? 1 : 0, that.maxRepeats().method_9041() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.method_8118() ? 1 : 0, that.method_8118() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = -Integer.compare(this.ingredients.size(), that.ingredients.size());
        return i;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<ItemExplodingRecipe> {
        public static final MapCodec<ItemExplodingRecipe> CODEC = ItemShapelessRecipeUtils.validatedCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)IngredientCollection.CODEC.optionalFieldOf("item_in", (Object)IngredientCollection.EMPTY).forGetter(it -> it.ingredients)).apply((Applicative)instance, ItemExplodingRecipe::new)));
        public static final class_9139<class_9129, ItemExplodingRecipe> STREAM_CODEC = class_9139.method_56435(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, IngredientCollection.STREAM_CODEC, it -> it.ingredients, ItemExplodingRecipe::new);

        @Override
        public MapCodec<ItemExplodingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, ItemExplodingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

