/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_4550;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.ItemInsideRecipeType;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.LycheeCounter;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ItemShapelessRecipeUtils;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class ItemInsideRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe {
    protected final class_4550 blockPredicate;
    protected final int time;
    protected boolean special;
    protected IngredientCollection ingredients;

    public ItemInsideRecipe(LycheeRecipeCommonProperties commonProperties, class_4550 blockPredicate, int time, IngredientCollection ingredients) {
        super(commonProperties);
        this.blockPredicate = blockPredicate;
        this.time = time;
        this.ingredients = ingredients;
        this.onConstructed();
    }

    public int time() {
        return this.time;
    }

    public boolean method_8118() {
        return this.special;
    }

    @Override
    public class_4550 blockPredicate() {
        return this.blockPredicate;
    }

    @Override
    public boolean tickOrApply(LycheeContext context) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        LycheeCounter counter = (LycheeCounter)lootParams.get(class_181.field_1226);
        if (counter.lychee$getCount() >= this.time) {
            counter.lychee$setRecipeId(null);
            return true;
        }
        return false;
    }

    public boolean matches(LycheeContext context, class_1937 level) {
        ItemShapelessContext itemShapelessContext = context.get(LycheeContextKey.ITEM_SHAPELESS);
        if (itemShapelessContext.totalItems < this.ingredients.size()) {
            return false;
        }
        if (!BlockPredicateExtensions.isAny(this.blockPredicate) && !BlockPredicateExtensions.matches(this.blockPredicate, context)) {
            return false;
        }
        return ItemShapelessRecipeUtils.matches(context, this.ingredients);
    }

    @Override
    public LycheeRecipeSerializer<ItemInsideRecipe> getSerializer() {
        return RecipeSerializers.ITEM_INSIDE;
    }

    public ItemInsideRecipeType getType() {
        return RecipeTypes.ITEM_INSIDE;
    }

    @Override
    public IngredientCollection ingredientCollection() {
        return this.ingredients;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<ItemInsideRecipe> {
        public static final MapCodec<ItemInsideRecipe> CODEC = ItemShapelessRecipeUtils.validatedCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("block_in", (Object)BlockPredicateExtensions.ANY).forGetter(ItemInsideRecipe::blockPredicate), (App)class_5699.field_33441.optionalFieldOf("time", (Object)0).forGetter(ItemInsideRecipe::time), (App)IngredientCollection.codec(1, Integer.MAX_VALUE).fieldOf("item_in").forGetter(ItemInsideRecipe::ingredientCollection)).apply((Applicative)instance, ItemInsideRecipe::new)));
        public static final class_9139<class_9129, ItemInsideRecipe> STREAM_CODEC = class_9139.method_56905(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (class_9139)class_4550.field_49181, ItemInsideRecipe::blockPredicate, (class_9139)class_9135.field_48550, ItemInsideRecipe::time, IngredientCollection.STREAM_CODEC, ItemInsideRecipe::ingredientCollection, ItemInsideRecipe::new);

        @Override
        public MapCodec<ItemInsideRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, ItemInsideRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

