/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.ItemInsideRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.LycheeCounter;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ItemShapelessRecipeType;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class ItemInsideRecipeType
extends LycheeRecipeType<ItemInsideRecipe> {
    private final List<class_8786<ItemInsideRecipe>> specialRecipes = Lists.newArrayList();
    private final Multimap<class_1792, class_8786<ItemInsideRecipe>> recipesByItem = ArrayListMultimap.create();

    public ItemInsideRecipeType(String name, Class<ItemInsideRecipe> clazz, @Nullable class_176 contextParamSet) {
        super(name, clazz, contextParamSet);
    }

    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        this.specialRecipes.clear();
        this.recipesByItem.clear();
        super.refreshCache();
        Object2FloatOpenHashMap itemWeights = new Object2FloatOpenHashMap();
        List caches = this.recipes.stream().filter(it -> {
            if (((ItemInsideRecipe)it.comp_1933()).method_8117().stream().noneMatch(CommonProxy::isSimpleIngredient)) {
                this.specialRecipes.add((class_8786<ItemInsideRecipe>)it);
                return false;
            }
            return true;
        }).map(recipeHolder -> new Cache((class_8786<ItemInsideRecipe>)recipeHolder, ((ItemInsideRecipe)recipeHolder.comp_1933()).sizedIngredients().stream().map(ingredient -> {
            List<class_1792> items = Arrays.stream(ingredient.getItems()).map(class_1799::method_7909).toList();
            float weight = (float)ingredient.count() / (float)items.size();
            for (class_1792 item : items) {
                itemWeights.merge((Object)item, weight, Float::sum);
            }
            return Sets.newHashSet(items);
        }).toList())).collect(Collectors.toList());
        List<class_1792> weightedItems = itemWeights.object2FloatEntrySet().stream().sorted((a, b) -> Float.compare(b.getFloatValue(), a.getFloatValue())).map(Map.Entry::getKey).toList();
        for (class_1792 item : weightedItems) {
            caches.removeIf(cache -> {
                if (cache.ingredients().stream().anyMatch(it -> it.contains(item))) {
                    this.recipesByItem.put((Object)item, cache.recipe());
                    return cache.ingredients().stream().peek(it -> it.remove(item)).anyMatch(Set::isEmpty);
                }
                return false;
            });
        }
    }

    @Override
    public Comparator<class_8786<ItemInsideRecipe>> comparator() {
        return Comparator.comparing(class_8786::comp_1933, Comparator.comparingInt($ -> $.method_8117().size()).thenComparingInt($ -> -$.time()).thenComparing($ -> !$.maxRepeats().method_9041()).thenComparing(class_1860::method_8118).reversed());
    }

    public void process(class_1297 entity, class_1799 stack, class_2338 pos, class_243 origin) {
        class_2960 prevRecipeId;
        if (this.isEmpty()) {
            return;
        }
        if (entity instanceof LycheeCounter) {
            LycheeCounter counter = (LycheeCounter)entity;
            prevRecipeId = counter.lychee$getRecipeId();
            counter.lychee$setRecipeId(null);
        } else {
            prevRecipeId = null;
        }
        Collection recipes = this.recipesByItem.get((Object)stack.method_7909());
        if (recipes.isEmpty() && this.specialRecipes.isEmpty()) {
            return;
        }
        class_1937 level = entity.method_37908();
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        List itemEntities = level.method_8390(class_1542.class, class_238.method_30048((class_243)origin, (double)3.0, (double)3.0, (double)3.0), it -> {
            if (it.method_31481()) {
                return false;
            }
            return pos.equals((Object)it.method_24515()) || level.method_8320(it.method_24515()).method_27852(block);
        });
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        ItemShapelessContext itemShapelessContext = new ItemShapelessContext(itemEntities, context);
        context.put(LycheeContextKey.ITEM_SHAPELESS, itemShapelessContext);
        LootParamsContext lootParams = context.initLootParams(this);
        lootParams.set(class_181.field_24424, CommonProxy.clampPos(origin, pos));
        lootParams.set(class_181.field_1226, entity);
        lootParams.set(class_181.field_1224, blockState);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, pos);
        lootParams.validate();
        class_8786 prevRecipe = Optional.ofNullable(prevRecipeId).map(CommonProxy::recipe).filter(it -> it.comp_1933() instanceof ItemInsideRecipe).orElse(null);
        Iterable allRecipes = Iterables.concat((Iterable)recipes, this.specialRecipes);
        if (prevRecipe != null) {
            allRecipes = Iterables.concat(List.of(prevRecipe), (Iterable)Iterables.filter((Iterable)allRecipes, it -> !it.equals((Object)prevRecipe)));
        }
        ItemShapelessRecipeType.process(this, allRecipes, context, it -> {
            ((LycheeCounter)entity).lychee$update(prevRecipeId, it);
            return ((ItemInsideRecipe)it.comp_1933()).tickOrApply(context);
        });
    }

    public record Cache(class_8786<ItemInsideRecipe> recipe, List<? extends Set<class_1792>> ingredients) {
    }
}

