/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.CraftingContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.mixin.recipes.crafting.ShapedRecipeAccess;
import snownee.lychee.mixin.recipes.crafting.ShapedRecipePatternAccess;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class ShapedCraftingRecipe
implements ILycheeRecipe<class_9694>,
class_3955 {
    private static final Cache<class_9694, LycheeContext> CONTEXT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build();
    protected final LycheeRecipeCommonProperties commonProperties;
    protected final class_1869 shaped;
    protected final List<PostAction> assemblingActions;

    public ShapedCraftingRecipe(LycheeRecipeCommonProperties commonProperties, class_1869 shaped, List<PostAction> assemblingActions) {
        this.commonProperties = commonProperties;
        this.assemblingActions = assemblingActions;
        this.shaped = shaped;
        this.onConstructed();
    }

    public ShapedCraftingRecipe(LycheeRecipeCommonProperties commonProperties, String group, class_7710 category, class_8957 pattern, class_1799 result, boolean showNotification, List<PostAction> assemblingActions) {
        this(commonProperties, new class_1869(group, category, pattern, result, showNotification), assemblingActions);
    }

    @Override
    public LycheeRecipeCommonProperties commonProperties() {
        return this.commonProperties;
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        int size = this.method_8117().size();
        if (pointer.size() == 1 && pointer.getString(0).equals("result")) {
            return IntList.of((int)size);
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("key")) {
            String key = pointer.getString(1);
            if (key.length() != 1) {
                return IntList.of();
            }
            class_8957 pattern = ((ShapedRecipeAccess)this.shaped).getPattern();
            Optional<class_8957.class_8958> dataOptional = ((ShapedRecipePatternAccess)pattern).data();
            if (dataOptional.isEmpty()) {
                return IntList.of();
            }
            class_8957.class_8958 data = dataOptional.get();
            IntArrayList list = IntArrayList.of();
            char cp = key.charAt(0);
            class_1856 ingredient = (class_1856)data.comp_2085().get(Character.valueOf(cp));
            for (int i = 0; i < this.method_8117().size(); ++i) {
                if (ingredient != this.method_8117().get(i)) continue;
                list.add(i);
            }
            return list;
        }
        return IntList.of((int)size);
    }

    public boolean matches(class_9694 input, class_1937 level) {
        if (this.ghost()) {
            return false;
        }
        if (level.field_9236) {
            return this.shaped.method_17728(input, level);
        }
        LycheeContext context = new LycheeContext();
        context.put(LycheeContextKey.LEVEL, level);
        context.put(LycheeContextKey.RECIPE, this);
        boolean mirror = false;
        boolean matched = false;
        ShapedRecipeAccess shapedRecipeAccess = (ShapedRecipeAccess)this.shaped;
        ShapedRecipePatternAccess pattern = (ShapedRecipePatternAccess)shapedRecipeAccess.getPattern();
        if (pattern.ingredientCount() != input.method_59990() || shapedRecipeAccess.getPattern().method_59995() != input.method_59991() || shapedRecipeAccess.getPattern().method_59996() != input.method_59992()) {
            return false;
        }
        if (this.getWidth() > 1 && pattern.callMatches(input, false)) {
            matched = true;
            mirror = true;
        } else if (pattern.callMatches(input, true)) {
            matched = true;
        }
        if (!matched) {
            return false;
        }
        CraftingContext craftingContext = new CraftingContext(context, input, mirror);
        context.put(LycheeContextKey.CRAFTING, craftingContext);
        boolean passed = this.conditions().test(this, context, 1) > 0;
        Pair pair = null;
        try {
            pair = (Pair)((Function)CraftingContext.CONTAINER_WORLD_LOCATOR.get(input.getClass())).apply(input);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        if (pair != null) {
            lootParams.set(class_181.field_24424, (class_243)pair.getFirst());
            lootParams.set(class_181.field_1226, (class_1297)pair.getSecond());
        }
        CONTEXT_CACHE.put((Object)input, (Object)context);
        if (passed) {
            class_1799 result = this.method_8110((class_7225.class_7874)level.method_30349()).method_7972();
            class_2371<class_1856> ingredients = this.method_8117();
            class_1799[] items = new class_1799[ingredients.size() + 1];
            int k = 0;
            for (int i = 0; i < this.getHeight(); ++i) {
                for (int j = 0; j < this.getWidth(); ++j) {
                    items[k] = input.method_59984(input.method_59991() * i + (craftingContext.mirror() ? this.getWidth() - j - 1 : j));
                    if (!items[k].method_7960()) {
                        items[k] = items[k].method_7972();
                        items[k].method_7939(1);
                    }
                    ++k;
                }
            }
            items[ingredients.size()] = result;
            context.put(LycheeContextKey.ITEM, ItemStackHolderCollection.Inventory.of(context, items));
        }
        return passed;
    }

    public class_1799 assemble(class_9694 container, class_7225.class_7874 provider) {
        LycheeContext context = (LycheeContext)((Object)CONTEXT_CACHE.getIfPresent((Object)container));
        if (context == null) {
            return class_1799.field_8037;
        }
        CraftingContext craftingContext = context.getOrNull(LycheeContextKey.CRAFTING);
        if (craftingContext == null) {
            return class_1799.field_8037;
        }
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        actionContext.reset();
        actionContext.jobs.addAll(this.assemblingActions.stream().map(it -> new Job((PostAction)it, 1)).toList());
        actionContext.run(context);
        return context.method_59984(context.method_59983() - 1);
    }

    public class_2371<class_1799> getRemainingItems(class_9694 container) {
        class_2371 items = this.shaped.method_8111((class_9695)container);
        LycheeContext context = (LycheeContext)((Object)CONTEXT_CACHE.getIfPresent((Object)container));
        if (context == null) {
            return items;
        }
        this.applyPostActions(context, 1);
        CraftingContext craftingContext = context.get(LycheeContextKey.CRAFTING);
        ItemStackHolderCollection itemStackHolders = context.get(LycheeContextKey.ITEM);
        int k = 0;
        for (int i = 0; i < this.getHeight(); ++i) {
            for (int j = 0; j < this.getWidth(); ++j) {
                if (((ExtendedItemStackHolder)itemStackHolders.get(k)).getConsumption() == 0) {
                    items.set(container.method_59991() * i + (craftingContext.mirror() ? this.getWidth() - j - 1 : j), (Object)context.method_59984(k));
                }
                ++k;
            }
        }
        return items;
    }

    public class_1865<ShapedCraftingRecipe> method_8119() {
        return RecipeSerializers.CRAFTING;
    }

    @Override
    public class_3956<? extends class_3955> method_17716() {
        return class_3956.field_17545;
    }

    public class_7710 method_45441() {
        return this.shaped.method_45441();
    }

    public String method_8112() {
        return this.shaped.method_8112();
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.shaped.method_8110(provider);
    }

    @Override
    public class_2371<class_1856> method_8117() {
        return this.shaped.method_8117();
    }

    public boolean method_49188() {
        return this.shaped.method_49188();
    }

    @Override
    public boolean method_8113(int width, int height) {
        return this.shaped.method_8113(width, height);
    }

    public int getWidth() {
        return this.shaped.method_8150();
    }

    public int getHeight() {
        return this.shaped.method_8158();
    }

    public boolean method_31584() {
        return this.shaped.method_31584();
    }

    public boolean method_8118() {
        return this.shaped.method_8118();
    }

    public class_1799 method_17447() {
        return this.shaped.method_17447();
    }

    public List<PostAction> assemblingActions() {
        return this.assemblingActions;
    }

    public class_1869 shaped() {
        return this.shaped;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<ShapedCraftingRecipe> {
        public static final MapCodec<ShapedCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(ILycheeRecipe::commonProperties), (App)class_1865.field_9035.method_53736().forGetter(ShapedCraftingRecipe::shaped), (App)PostAction.LIST_CODEC.optionalFieldOf("assembling", List.of()).forGetter(ShapedCraftingRecipe::assemblingActions)).apply((Applicative)instance, ShapedCraftingRecipe::new));
        public static final class_9139<class_9129, ShapedCraftingRecipe> STREAM_CODEC = class_9139.method_56436(LycheeRecipeCommonProperties.STREAM_CODEC, ShapedCraftingRecipe::commonProperties, (class_9139)class_9135.method_56896((Codec)class_1865.field_9035.method_53736().codec()), ShapedCraftingRecipe::shaped, PostAction.STREAM_LIST_CODEC, ShapedCraftingRecipe::assemblingActions, ShapedCraftingRecipe::new);

        @Override
        public MapCodec<ShapedCraftingRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, ShapedCraftingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

