/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5689;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Mod;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KEvent;
import snownee.kiwi.util.KUtil;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.LycheeTags;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.action.CustomAction;
import snownee.lychee.compat.recipe_api.AlwaysTrueIngredient;
import snownee.lychee.compat.recipe_api.VisualOnlyComponentsIngredient;
import snownee.lychee.compat.recipeviewer.IngredientType;
import snownee.lychee.contextual.CustomCondition;
import snownee.lychee.recipes.BlockClickingRecipe;
import snownee.lychee.recipes.BlockInteractingRecipe;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.context.LycheeContextSerializers;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.particles.dripstone.DripstoneParticleService;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.ui.UIElementType;

@Mod(value="lychee")
public class CommonProxy
implements ModInitializer {
    public static final KEvent<CustomActionListener> CUSTOM_ACTION_EVENT = KEvent.createArrayBacked(CustomActionListener.class, listeners -> (id, action, recipe) -> {
        for (CustomActionListener listener : listeners) {
            if (!listener.on(id, action, recipe)) continue;
            return true;
        }
        return false;
    });
    public static final KEvent<CustomConditionListener> CUSTOM_CONDITION_EVENT = KEvent.createArrayBacked(CustomConditionListener.class, listeners -> (id, condition) -> {
        for (CustomConditionListener listener : listeners) {
            if (!listener.on(id, condition)) continue;
            return true;
        }
        return false;
    });
    private static final Random RANDOM = new Random();
    public static boolean hasDFLib = Platform.isModLoaded((String)"dripstone_fluid_lib");

    public static void dropItemStack(class_1937 pLevel, double pX, double pY, double pZ, class_1799 pStack, @Nullable Consumer<class_1542> extraStep) {
        while (!pStack.method_7960()) {
            class_1542 itementity = new class_1542(pLevel, pX, pY, pZ, pStack.method_7971(Math.min(RANDOM.nextInt(21) + 10, pStack.method_7914())));
            itementity.method_18800(RANDOM.nextGaussian() * 0.05 - 0.025, RANDOM.nextGaussian() * 0.05 + 0.2, RANDOM.nextGaussian() * 0.05 - 0.025);
            if (extraStep != null) {
                extraStep.accept(itementity);
            }
            pLevel.method_8649((class_1297)itementity);
        }
    }

    public static String makeDescriptionId(String pType, @Nullable class_2960 pId) {
        return pId == null ? pType + ".unregistered_sadface" : pType + "." + CommonProxy.wrapNamespace(pId.method_12836()) + "." + pId.method_12832().replace('/', '.');
    }

    public static String wrapNamespace(String modid) {
        return "minecraft".equals(modid) ? "lychee" : modid;
    }

    public static class_5250 white(CharSequence s) {
        return class_2561.method_43470((String)s.toString()).method_27692(class_124.field_1068);
    }

    public static String chance(float chance) {
        if (chance >= 0.1f) {
            return (int)(chance * 100.0f) + "%";
        }
        if (chance >= 0.001f) {
            return String.format("%.1f%%", Float.valueOf(chance * 100.0f));
        }
        return "<0.1%";
    }

    public static String capitaliseAllWords(String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static <T> T getCycledItem(List<T> list, T fallback, int interval) {
        if (list.isEmpty()) {
            return fallback;
        }
        if (list.size() == 1) {
            return list.getFirst();
        }
        long index = System.currentTimeMillis() / (long)interval % (long)list.size();
        return list.get(Math.toIntExact(index));
    }

    @Nullable
    public static class_8786<?> recipe(class_2960 id) {
        class_1863 manager = KUtil.getRecipeManager();
        if (manager == null) {
            return null;
        }
        return manager.method_8130(id).orElse(null);
    }

    public static class_2338 getOnPos(class_1297 entity) {
        int i = class_3532.method_15357((double)entity.method_23317());
        int j = class_3532.method_15357((double)(entity.method_23318() - 0.05));
        int k = class_3532.method_15357((double)entity.method_23321());
        class_2338 blockpos = new class_2338(i, j, k);
        if (entity.method_37908().method_22347(blockpos)) {
            class_2338 blockpos1 = blockpos.method_10074();
            class_2680 blockstate = entity.method_37908().method_8320(blockpos1);
            if (CommonProxy.collisionExtendsVertically(blockstate, entity.method_37908(), blockpos1, entity)) {
                return blockpos1;
            }
        }
        return blockpos;
    }

    public static boolean collisionExtendsVertically(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        return state.method_26164(class_3481.field_16584) || state.method_26164(class_3481.field_15504) || state.method_26204() instanceof class_2349;
    }

    public static class_243 clampPos(class_243 origin, class_2338 pos) {
        double x = CommonProxy.clamp(origin.field_1352, pos.method_10263());
        double y = CommonProxy.clamp(origin.field_1351, pos.method_10264());
        double z = CommonProxy.clamp(origin.field_1350, pos.method_10260());
        if (x == origin.field_1352 && y == origin.field_1351 && z == origin.field_1350) {
            return origin;
        }
        return new class_243(x, y, z);
    }

    private static double clamp(double v, int target) {
        if (v < (double)target) {
            return target;
        }
        if (v >= (double)(target + 1)) {
            return (double)target + 0.999999;
        }
        return v;
    }

    public static boolean isSimpleIngredient(class_1856 ingredient) {
        return !ingredient.requiresTesting();
    }

    public static JsonObject tagToJson(class_2487 tag) {
        return ((JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)tag)).getAsJsonObject();
    }

    public static class_2487 jsonToTag(JsonElement json) {
        if (json.isJsonObject()) {
            return (class_2487)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, json);
        }
        try {
            return class_2522.method_10718((String)json.getAsString());
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void registerCustomActionListener(CustomActionListener listener) {
        CUSTOM_ACTION_EVENT.register((Object)listener);
    }

    public static void registerCustomConditionListener(CustomConditionListener listener) {
        CUSTOM_CONDITION_EVENT.register((Object)listener);
    }

    public static void postCustomActionEvent(String id, CustomAction action, ILycheeRecipe<?> recipe) {
        ((CustomActionListener)CUSTOM_ACTION_EVENT.invoker()).on(id, action, recipe);
    }

    public static void postCustomConditionEvent(String id, CustomCondition condition) {
        ((CustomConditionListener)CUSTOM_CONDITION_EVENT.invoker()).on(id, condition);
    }

    public static IngredientType getIngredientType(class_1856 ingredient) {
        CustomIngredient customIngredient = ingredient.getCustomIngredient();
        if (customIngredient != null && customIngredient.getSerializer() == AlwaysTrueIngredient.SERIALIZER) {
            return IngredientType.ANY;
        }
        if (ingredient.method_8103()) {
            return IngredientType.AIR;
        }
        return IngredientType.NORMAL;
    }

    public static boolean dispensePlacement(class_2342 pSource, class_1799 pStack, class_2350 direction) {
        class_1792 class_17922 = pStack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 item = (class_1747)class_17922;
        class_2338 blockpos = pSource.comp_1968().method_10093(direction);
        class_2680 state = pSource.comp_1967().method_8320(blockpos);
        if (!class_2346.method_10128((class_2680)state)) {
            return false;
        }
        class_2248 class_22482 = item.method_7711();
        if (class_22482 instanceof class_5689) {
            class_5689 block = (class_5689)class_22482;
            class_2680 blockState = (class_2680)block.method_9564().method_11657((class_2769)class_5689.field_28050, (Comparable)class_2350.field_11033);
            class_1540 entity = class_1540.method_40005((class_1937)pSource.comp_1967(), (class_2338)blockpos, (class_2680)blockState);
            float f = 6.0f;
            entity.method_6965(f, 40);
            pStack.method_7934(1);
            return true;
        }
        try {
            item.method_7712((class_1750)new class_2968((class_1937)pSource.comp_1967(), blockpos, direction, pStack, direction));
        }
        catch (Exception exception) {
            Lychee.LOGGER.error("Error trying to place block at {}", (Object)blockpos, (Object)exception);
        }
        return false;
    }

    public static <T> String getTagTranslationKey(class_6862<T> key) {
        return key.getTranslationKey();
    }

    public static void hurtAndBreak(class_1799 itemStack, int damage, class_3218 level, @Nullable class_1309 entity) {
        class_3222 player;
        itemStack.method_7956(damage, level, entity instanceof class_3222 ? (player = (class_3222)entity) : null, $ -> {});
    }

    public void onInitialize() {
        Objects.requireNonNull(RecipeTypes.ALL);
        Objects.requireNonNull(LycheeTags.FIRE_IMMUNE);
        Objects.requireNonNull(LycheeRegistries.CONTEXTUAL);
        Objects.requireNonNull(ContextualConditionType.AND);
        Objects.requireNonNull(PostActionTypes.DROP_ITEM);
        Objects.requireNonNull(RecipeSerializers.ITEM_BURNING);
        Objects.requireNonNull(LycheeContextKey.ACTION);
        Objects.requireNonNull(UIElementType.SPRITE);
        LycheeContextSerializers.init();
        CustomIngredientSerializer.register(AlwaysTrueIngredient.SERIALIZER);
        CustomIngredientSerializer.register(VisualOnlyComponentsIngredient.SERIALIZER);
        UseBlockCallback.EVENT.register(BlockInteractingRecipe::invoke);
        AttackBlockCallback.EVENT.register(BlockClickingRecipe::invoke);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Lychee.id("dripstone_dripping"), DripstoneParticleService.DRIPSTONE_DRIPPING);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Lychee.id("dripstone_falling"), DripstoneParticleService.DRIPSTONE_FALLING);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)Lychee.id("dripstone_splash"), DripstoneParticleService.DRIPSTONE_SPLASH);
    }

    public static interface CustomActionListener {
        public boolean on(String var1, CustomAction var2, ILycheeRecipe<?> var3);
    }

    public static interface CustomConditionListener {
        public boolean on(String var1, CustomCondition var2);
    }
}

