/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.util.NonNullListExtensions;
import snownee.lychee.util.codec.LycheeCodecs;

public final class IngredientCollection {
    public static final IngredientCollection EMPTY = new IngredientCollection(List.of());
    public static final Codec<IngredientCollection> CODEC = KCodecs.compactList(LycheeCodecs.SIZED_INGREDIENT).xmap(IngredientCollection::new, IngredientCollection::ingredients);
    public static final class_9139<class_9129, IngredientCollection> STREAM_CODEC = class_9139.method_56434((class_9139)SizedIngredient.STREAM_CODEC.method_56433(class_9135.method_56363()), IngredientCollection::ingredients, IngredientCollection::of);
    private final List<SizedIngredient> ingredients;
    private final int ingredientCount;
    private class_2371<class_1856> flattenedIngredients;

    public static Codec<IngredientCollection> codec(int minSize, int maxSize) {
        return LycheeCodecs.sizeLimit(KCodecs.compactList(LycheeCodecs.SIZED_INGREDIENT), minSize, maxSize).xmap(IngredientCollection::of, IngredientCollection::ingredients);
    }

    public static IngredientCollection of(List<SizedIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return EMPTY;
        }
        return new IngredientCollection(ingredients);
    }

    public IngredientCollection(List<SizedIngredient> ingredients) {
        this.ingredients = ingredients;
        this.ingredientCount = ingredients.stream().mapToInt(SizedIngredient::count).sum();
    }

    public List<SizedIngredient> ingredients() {
        return this.ingredients;
    }

    public int size() {
        return this.ingredients.size();
    }

    public boolean isEmpty() {
        return this.ingredients.isEmpty();
    }

    public int ingredientCount() {
        return this.ingredientCount;
    }

    public class_2371<class_1856> flattenedIngredients() {
        if (this.flattenedIngredients == null) {
            ArrayList list = Lists.newArrayListWithExpectedSize((int)this.ingredientCount);
            for (SizedIngredient ingredient : this.ingredients) {
                for (int i = 0; i < ingredient.count(); ++i) {
                    list.add(ingredient.ingredient());
                }
            }
            this.flattenedIngredients = NonNullListExtensions.copyOf(list);
        }
        return this.flattenedIngredients;
    }

    public boolean anyMatch(class_1799 itemStack) {
        for (SizedIngredient ingredient : this.ingredients) {
            if (!ingredient.ingredient().method_8093(itemStack)) continue;
            return true;
        }
        return false;
    }
}

