/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.util.codec.KCodecs;
import snownee.lychee.Lychee;

public class Patterns
implements Predicate<String> {
    public static final Codec<Patterns> CODEC = class_5699.method_36973((Codec)KCodecs.compactList((Codec)class_5699.field_41759)).xmap(Patterns::new, Patterns::strings);
    public static final class_9139<ByteBuf, Patterns> STREAM_CODEC = class_9135.field_48554.method_56433(class_9135.method_56363()).method_56432(Patterns::new, Patterns::strings);
    public static final Patterns EMPTY = new Patterns(List.of());
    private final List<String> strings;
    @Nullable
    private List<Pattern> patterns;

    public Patterns(List<String> strings) {
        this.strings = strings;
    }

    public List<String> strings() {
        return this.strings;
    }

    public List<Pattern> patterns() {
        if (this.patterns == null) {
            this.patterns = this.strings.stream().map(it -> {
                try {
                    return Pattern.compile(it);
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("Failed to compile pattern: {}", it);
                    return null;
                }
            }).filter(Objects::nonNull).toList();
        }
        return this.patterns;
    }

    @Override
    public boolean test(String s) {
        if (this.strings.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.patterns()) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }
}

