/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.action.CycleStateProperty;
import snownee.lychee.action.DropItem;
import snownee.lychee.action.PlaceBlock;
import snownee.lychee.action.RandomSelect;
import snownee.lychee.action.SetBlock;
import snownee.lychee.action.input.DamageItem;
import snownee.lychee.action.input.PreventDefault;
import snownee.lychee.action.input.SetItem;
import snownee.lychee.client.action.IfActionRenderer;
import snownee.lychee.compat.recipeviewer.IngredientInfo;
import snownee.lychee.compat.recipeviewer.SlotType;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.BlockBasedActionRenderer;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public interface ActionRenderer<T extends PostAction> {
    public static final Map<PostActionType<?>, ActionRenderer<?>> RENDERERS = Maps.newIdentityHashMap();
    public static final ActionRenderer<PostAction> DEFAULT = new ActionRenderer<PostAction>(){};

    public static void init() {
        ActionRenderer.register(PostActionTypes.DROP_ITEM, DropItem::itemStack);
        ActionRenderer.register(PostActionTypes.SET_ITEM, SetItem::itemStack);
        ActionRenderer.register(PostActionTypes.DROP_XP, action -> class_1802.field_8287.method_7854());
        ActionRenderer.register(PostActionTypes.EXECUTE, action -> class_1802.field_8866.method_7854());
        ActionRenderer.register(PostActionTypes.EXPLODE, action -> class_1802.field_8626.method_7854());
        ActionRenderer.register(PostActionTypes.IF, new IfActionRenderer());
        ActionRenderer.register(PostActionTypes.PLACE, BlockBasedActionRenderer.fromPredicate(PlaceBlock::block));
        ActionRenderer.register(PostActionTypes.SET_BLOCK, BlockBasedActionRenderer.fromPredicate(SetBlock::block));
        ActionRenderer.register(PostActionTypes.CYCLE_STATE_PROPERTY, new BlockBasedActionRenderer<CycleStateProperty>(it -> {
            List<class_2680> blockStates = BlockPredicateExtensions.getShowcaseBlockStates(it.block(), Set.of(it.property()));
            return CommonProxy.getCycledItem(blockStates, class_2246.field_10124.method_9564(), 1000);
        }));
        ActionRenderer.register(PostActionTypes.DAMAGE_ITEM, new ActionRenderer<DamageItem>(){

            @Override
            public void loadCatalystsInfo(DamageItem action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
                String key = CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.method_10221(action.type()));
                class_5250 component = class_2561.method_43469((String)key, (Object[])new Object[]{action.damage()}).method_27692(class_124.field_1054);
                class_310 mc = class_310.method_1551();
                recipe.getItemIndexes(action.target()).forEach(i -> {
                    IngredientInfo info = (IngredientInfo)ingredients.get(i);
                    info.addTooltip((class_2561)component);
                    action.conditions().appendToTooltips(info.tooltips, (class_1937)mc.field_1687, (class_1657)mc.field_1724, 0);
                    info.type = SlotType.CATALYST;
                    info.relatedAction = action;
                });
            }
        });
        ActionRenderer.register(PostActionTypes.PREVENT_DEFAULT, new ActionRenderer<PreventDefault>(){

            @Override
            public void loadCatalystsInfo(PreventDefault action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
                LycheeRecipeType lycheeRecipeType;
                block4: {
                    block3: {
                        class_3956<class_1860<?>> class_39562 = recipe.method_17716();
                        if (!(class_39562 instanceof LycheeRecipeType)) break block3;
                        lycheeRecipeType = (LycheeRecipeType)class_39562;
                        if (lycheeRecipeType.canPreventConsumeInputs) break block4;
                    }
                    return;
                }
                class_310 mc = class_310.method_1551();
                for (IngredientInfo info : ingredients) {
                    if (!info.tooltips.isEmpty()) continue;
                    info.addTooltip(lycheeRecipeType.getPreventDefaultDescription(recipe));
                    action.conditions().appendToTooltips(info.tooltips, (class_1937)mc.field_1687, (class_1657)mc.field_1724, 0);
                    info.type = SlotType.CATALYST;
                    info.relatedAction = action;
                }
            }
        });
    }

    public static <T extends PostAction> ActionRenderer<T> of(PostAction action) {
        return Objects.requireNonNull(RENDERERS.getOrDefault(action.type(), DEFAULT));
    }

    public static <T extends PostAction> void register(PostActionType<T> type, ActionRenderer<T> renderer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(renderer);
        RENDERERS.put(type, renderer);
    }

    public static List<class_2561> getTooltipsFromRandom(RandomSelect randomSelect, PostAction child, @Nullable class_1657 player) {
        int c;
        ArrayList list;
        int index = -1;
        for (int i = 0; i < randomSelect.entries().size(); ++i) {
            if (!randomSelect.entries().get(i).action().equals(child)) continue;
            index = i;
        }
        ArrayList arrayList = list = randomSelect.entries().size() == 1 && randomSelect.emptyWeight() == 0 ? Lists.newArrayList((Object[])new class_2561[]{randomSelect.getDisplayName()}) : ActionRenderer.of(child).getBaseTooltips(child, player);
        if (index == -1) {
            return list;
        }
        if (randomSelect.entries().size() > 1 || randomSelect.emptyWeight() > 0) {
            String chance = CommonProxy.chance((float)randomSelect.entries().get(index).weight() / (float)randomSelect.totalWeight());
            if (randomSelect.rolls() == BoundsExtensions.ONE) {
                list.add(class_2561.method_43469((String)"tip.lychee.randomChance.one", (Object[])new Object[]{chance}).method_27692(class_124.field_1054));
            } else {
                list.add(class_2561.method_43469((String)"tip.lychee.randomChance", (Object[])new Object[]{chance, BoundsExtensions.getPlainDescription(randomSelect.rolls())}).method_27692(class_124.field_1054));
            }
        }
        if ((c = randomSelect.conditions().showingCount() + child.conditions().showingCount()) > 0) {
            list.add(ClientProxy.format("contextual.lychee", c).method_27692(class_124.field_1080));
        }
        class_310 mc = class_310.method_1551();
        randomSelect.conditions().appendToTooltips(list, (class_1937)mc.field_1687, (class_1657)mc.field_1724, 0);
        child.conditions().appendToTooltips(list, (class_1937)mc.field_1687, (class_1657)mc.field_1724, 0);
        return list;
    }

    default public void internalRender(T action, class_332 graphics, int x, int y) {
        class_2960 sprite;
        if (!action.hidden() && (sprite = action.commonProperties().icon()) != null) {
            graphics.method_52706(sprite, x, y, 16, 16);
            return;
        }
        this.render(action, graphics, x, y);
    }

    default public void render(T action, class_332 graphics, int x, int y) {
    }

    default public List<class_2561> getBaseTooltips(T action, @Nullable class_1657 player) {
        return Lists.newArrayList((Object[])new class_2561[]{action.getDisplayName()});
    }

    default public List<class_2561> getTooltips(T action, @Nullable class_1657 player) {
        ArrayList list = Lists.newArrayList(this.getBaseTooltips(action, player));
        ActionRenderer.appendConditionTooltips(list, action, player);
        return list;
    }

    default public void loadCatalystsInfo(T action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
    }

    public static void appendConditionTooltips(List<class_2561> tooltips, PostAction action, @Nullable class_1657 player) {
        int c = action.conditions().showingCount();
        if (c > 0) {
            tooltips.add((class_2561)ClientProxy.format("contextual.lychee", c).method_27692(class_124.field_1080));
        }
        class_310 mc = class_310.method_1551();
        action.conditions().appendToTooltips(tooltips, (class_1937)mc.field_1687, player, 0);
    }
}

