/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4550;
import snownee.lychee.action.AddItemCooldown;
import snownee.lychee.action.Delay;
import snownee.lychee.action.DropItem;
import snownee.lychee.action.DropXp;
import snownee.lychee.action.Execute;
import snownee.lychee.action.Move;
import snownee.lychee.action.PlaceBlock;
import snownee.lychee.action.SetBlock;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.codec.LycheeParser;
import snownee.lychee.util.codec.LycheeParserUtils;
import snownee.lychee.util.codec.ParsedItem;

public interface ActionParsers {

    public static class ItemCooldown
    implements LycheeParser<AddItemCooldown> {
        @Override
        public DataResult<AddItemCooldown> parse(StringReader reader) throws CommandSyntaxException {
            DataResult result = LycheeParserUtils.readParam(reader, r -> LycheeCodecs.tryCatch(() -> {
                float f = r.readFloat();
                Preconditions.checkArgument((f > 0.0f ? 1 : 0) != 0, (Object)"Cooldown must be positive");
                return Float.valueOf(f);
            })).orElseThrow();
            return result.map(f -> new AddItemCooldown(PostActionCommonProperties.EMPTY, f.floatValue(), Optional.empty()));
        }
    }

    public static class DelayParser
    implements LycheeParser<Delay> {
        @Override
        public DataResult<Delay> parse(StringReader reader) throws CommandSyntaxException {
            DataResult result = LycheeParserUtils.readParam(reader, r -> LycheeCodecs.tryCatch(() -> {
                float f = r.readFloat();
                Preconditions.checkArgument((f > 0.0f ? 1 : 0) != 0, (Object)"Delay must be positive");
                return Float.valueOf(f);
            })).orElseThrow();
            return result.map(f -> new Delay(PostActionCommonProperties.EMPTY, f.floatValue()));
        }
    }

    public static class Run
    implements LycheeParser<Execute> {
        @Override
        public DataResult<Execute> parse(StringReader reader) throws CommandSyntaxException {
            DataResult result = LycheeParserUtils.readParam(reader, r -> LycheeCodecs.tryCatch(() -> ((StringReader)reader).readQuotedString())).orElseThrow();
            return result.map(s -> new Execute(PostActionCommonProperties.EMPTY, (String)s, false));
        }
    }

    public static class Drop
    implements LycheeParser<PostAction> {
        @Override
        public DataResult<PostAction> parse(StringReader reader) throws CommandSyntaxException {
            DataResult itemResult = LycheeParserUtils.readParam(reader, r -> LycheeCodecs.tryCatch(() -> ParsedItem.read(reader).itemStack())).orElseThrow();
            if (itemResult.isSuccess()) {
                return itemResult.map(item -> new DropItem(PostActionCommonProperties.EMPTY, (class_1799)item));
            }
            DataResult xpResult = LycheeParserUtils.readParam(reader, r -> LycheeCodecs.tryCatch(() -> {
                int i = r.readInt();
                r.expect('x');
                r.expect('p');
                Preconditions.checkArgument((i > 0 ? 1 : 0) != 0, (Object)"XP must be positive");
                return i;
            })).orElseThrow();
            if (xpResult.isSuccess()) {
                return xpResult.map(xp -> new DropXp(PostActionCommonProperties.EMPTY, (int)xp));
            }
            return DataResult.error(() -> "Failed to parse drop action: <Item: %s; XP: %s>".formatted(((DataResult.Error)itemResult.error().orElseThrow()).message(), ((DataResult.Error)xpResult.error().orElseThrow()).message()));
        }
    }

    public static class MoveParser
    implements LycheeParser<Move> {
        @Override
        public DataResult<Move> parse(StringReader reader) throws CommandSyntaxException {
            DataResult vecResult = LycheeParserUtils.readParam(reader, LycheeParserUtils::readVec3).orElseThrow();
            return vecResult.map(vec -> new Move(PostActionCommonProperties.EMPTY, (class_243)vec, ""));
        }
    }

    public static class SetBlockParser
    implements LycheeParser<SetBlock> {
        @Override
        public DataResult<SetBlock> parse(StringReader reader) throws CommandSyntaxException {
            DataResult blockResult = LycheeParserUtils.readParam(reader, r -> LycheeParserUtils.readBlock(reader, false)).orElseThrow();
            return blockResult.map(block -> new SetBlock(PostActionCommonProperties.EMPTY, (class_4550)block));
        }
    }

    public static class Place
    implements LycheeParser<PlaceBlock> {
        @Override
        public DataResult<PlaceBlock> parse(StringReader reader) throws CommandSyntaxException {
            DataResult blockResult = LycheeParserUtils.readParam(reader, r -> LycheeParserUtils.readBlock(reader, false)).orElseThrow();
            if (blockResult.isError()) {
                return DataResult.error(() -> ((DataResult.Error)blockResult.error().orElseThrow()).message());
            }
            class_2338 offset = class_2338.field_10980;
            Optional offsetResult = LycheeParserUtils.readParam(reader, LycheeParserUtils::readPos);
            if (offsetResult.isPresent() && offsetResult.get().isSuccess()) {
                offset = (class_2338)offsetResult.get().getOrThrow();
            }
            return DataResult.success((Object)new PlaceBlock(PostActionCommonProperties.EMPTY, (class_4550)blockResult.getOrThrow(), offset));
        }
    }
}

