/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2291;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.util.codec.ParsedItem;
import snownee.lychee.util.codec.ThrowingSupplier;

public final class LycheeCodecs {
    private static final MapCodec<Integer> ITEM_STACK_COUNT = class_5699.field_33441.fieldOf("count").orElse((Object)1);
    private static final MapCodec<class_1799> ITEM_STACK_MAP_ENCODER = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_40294().fieldOf("id").forGetter(class_1799::method_41409), (App)ITEM_STACK_COUNT.forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new));
    public static final MapCodec<class_1799> ITEM_STACK_MAP_CODEC = MapCodec.of(ITEM_STACK_MAP_ENCODER, (MapDecoder)new MapDecoder.Implementation<class_1799>(){

        public <T> DataResult<class_1799> decode(DynamicOps<T> ops, MapLike<T> input) {
            class_2291.class_7215 itemResult;
            DataResult result = ITEM_STACK_MAP_ENCODER.decode(ops, input);
            if (result.isSuccess()) {
                return result;
            }
            Object id = input.get("id");
            if (id == null) {
                return DataResult.error(() -> "Missing id");
            }
            if (!(ops instanceof class_6903)) {
                return DataResult.error(() -> "Not a registry ops");
            }
            final class_6903 registryOps = (class_6903)ops;
            class_2291 parser = new class_2291(new class_7225.class_7874(){

                public Stream<class_5321<? extends class_2378<?>>> method_55282() {
                    throw new IllegalStateException();
                }

                public <R> Optional<class_7225.class_7226<R>> method_46759(class_5321<? extends class_2378<? extends R>> resourceKey) {
                    return Optional.of(class_7923.field_41178.method_46771());
                }

                public <V> class_6903<V> method_57093(DynamicOps<V> dynamicOps) {
                    return registryOps.method_57110(dynamicOps);
                }
            });
            try {
                itemResult = parser.method_9789(new StringReader((String)ops.getStringValue(id).getOrThrow()));
            }
            catch (Exception e) {
                return DataResult.error(e::getMessage);
            }
            if (input.get("components") != null) {
                return DataResult.error(() -> "id with brackets cannot have the components field");
            }
            DataResult count = class_5699.field_33442.optionalFieldOf("count", (Object)1).decode(ops, input);
            if (count.isError()) {
                return DataResult.error(() -> "Failed to decode count: " + ((DataResult.Error)count.error().orElseThrow()).message());
            }
            return DataResult.success((Object)new class_1799(itemResult.comp_628(), ((Integer)count.getOrThrow()).intValue(), itemResult.comp_2439()));
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return ITEM_STACK_MAP_ENCODER.keys(ops);
        }
    }, () -> "MapCodec[ItemStack]");
    public static final MapCodec<class_1799> NONEMPTY_ITEM_STACK_MAP_CODEC = ITEM_STACK_MAP_CODEC.validate(stack -> {
        if (stack.method_7960()) {
            return DataResult.error(() -> "ItemStack cannot be empty");
        }
        return DataResult.success((Object)stack);
    });
    public static final Codec<class_1799> ITEM_STACK = Codec.withAlternative((Codec)NONEMPTY_ITEM_STACK_MAP_CODEC.codec(), (Codec)class_5699.field_41759.flatXmap(s -> LycheeCodecs.tryCatch(() -> ParsedItem.read(new StringReader(s)).itemStack()), stack -> DataResult.error(() -> "Encoding shorthand ItemStack is not supported")));
    public static final MapCodec<class_2338> OFFSET = RecordCodecBuilder.mapCodec(posInstance -> posInstance.group((App)Codec.INT.optionalFieldOf("offsetX", (Object)0).forGetter(class_2382::method_10263), (App)Codec.INT.optionalFieldOf("offsetY", (Object)0).forGetter(class_2382::method_10264), (App)Codec.INT.optionalFieldOf("offsetZ", (Object)0).forGetter(class_2382::method_10260)).apply((Applicative)posInstance, (x, y, z) -> {
        if (x == 0 && y == 0 && z == 0) {
            return class_2338.field_10980;
        }
        return new class_2338(x.intValue(), y.intValue(), z.intValue());
    }));
    public static final Codec<class_1856> NONEMPTY_INGREDIENT = Codec.withAlternative((Codec)class_1856.field_46096, (Codec)class_5699.field_41759.flatXmap(s -> LycheeCodecs.tryCatch(() -> {
        StringReader reader = new StringReader(s);
        ParsedItem parsedItem = ParsedItem.read(reader);
        Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Cannot parse %s", (Object)s);
        return parsedItem.ingredient();
    }), ingredient -> DataResult.error(() -> "Encoding shorthand Ingredient is not supported")));
    public static final Codec<SizedIngredient> SIZED_INGREDIENT = Codec.withAlternative((Codec)SizedIngredient.CODEC, (Codec)class_5699.field_41759.flatXmap(s -> LycheeCodecs.tryCatch(() -> {
        StringReader reader = new StringReader(s);
        ParsedItem parsedItem = ParsedItem.read(reader);
        Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Cannot parse %s", (Object)s);
        return parsedItem.sizedIngredient();
    }), ingredient -> DataResult.error(() -> "Encoding shorthand SizedIngredient is not supported")));

    public static <T, L extends List<T>> Codec<L> sizeLimit(Codec<L> listCodec, int minSize, int maxSize) {
        return listCodec.validate(list -> {
            if (list.size() < minSize) {
                return DataResult.error(() -> "List is too short: " + minSize + ", expected range [" + minSize + "-" + maxSize + "]");
            }
            if (list.size() > maxSize) {
                return DataResult.error(() -> "List is too long: " + maxSize + ", expected range [" + minSize + "-" + maxSize + "]");
            }
            return DataResult.success((Object)list);
        });
    }

    public static <T> DataResult<T> tryCatch(ThrowingSupplier<T> supplier) {
        try {
            return DataResult.success(supplier.get());
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }
}

