/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4550;
import net.minecraft.class_5462;
import snownee.lychee.util.codec.ThrowingFunction;
import snownee.lychee.util.predicates.BlockPredicateExtensions;

public class LycheeParserUtils {
    private static final char SYNTAX_ESCAPE = '\\';

    public static String readStringUntil(StringReader reader, class_5462 predicate) throws CommandSyntaxException {
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                if (predicate.test(c) || c == '\\') {
                    result.append(c);
                    escaped = false;
                    continue;
                }
                reader.setCursor(reader.getCursor() - 1);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidEscape().createWithContext((ImmutableStringReader)reader, (Object)String.valueOf(c));
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (predicate.test(c)) {
                reader.setCursor(reader.getCursor() - 1);
                return result.toString();
            }
            result.append(c);
        }
        return result.toString();
    }

    public static DataResult<class_4550> readBlock(StringReader reader, boolean forTesting) throws CommandSyntaxException {
        char c2;
        StringBuilder sb = new StringBuilder();
        sb.append(LycheeParserUtils.readStringUntil(reader, c -> c == ' ' || c == '[' || c == '{'));
        if (reader.canRead() && (c2 = reader.peek()) == '[') {
            sb.append(reader.readStringUntil(']')).append(']');
        }
        if (reader.canRead() && (c2 = reader.peek()) == '{') {
            sb.append(reader.readStringUntil('}')).append('}');
        }
        return BlockPredicateExtensions.fromString(sb.toString(), forTesting);
    }

    public static DataResult<class_2338> readPos(StringReader reader) throws CommandSyntaxException {
        int x = reader.readInt();
        reader.expect(' ');
        int y = reader.readInt();
        reader.expect(' ');
        int z = reader.readInt();
        return DataResult.success((Object)new class_2338(x, y, z));
    }

    public static DataResult<class_243> readVec3(StringReader reader) throws CommandSyntaxException {
        double x = reader.readDouble();
        reader.expect(' ');
        double y = reader.readDouble();
        reader.expect(' ');
        double z = reader.readDouble();
        return DataResult.success((Object)new class_243(x, y, z));
    }

    public static <T> Optional<DataResult<T>> readParam(StringReader reader, ThrowingFunction<StringReader, DataResult<T>> parser) {
        int cursor = reader.getCursor();
        try {
            reader.expect(' ');
            DataResult<T> result = parser.apply(reader);
            if (result.isError()) {
                reader.setCursor(cursor);
            }
            return Optional.of(result);
        }
        catch (Exception ignored) {
            reader.setCursor(cursor);
            return Optional.empty();
        }
    }
}

