/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.codec;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import snownee.kiwi.recipe.SizedIngredient;

public record ParsedItem(class_5699.class_7476 tagOrId, int count) {
    public static ParsedItem read(StringReader input) throws CommandSyntaxException {
        return ParsedItem.read(input, false);
    }

    public static ParsedItem read(StringReader input, boolean single) throws CommandSyntaxException {
        int count = 1;
        int cursor = input.getCursor();
        try {
            count = input.readInt();
            input.expect('x');
            input.expect(' ');
            Preconditions.checkArgument((!single ? 1 : 0) != 0, (Object)"Count not allowed here");
            Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be positive");
        }
        catch (CommandSyntaxException ignored) {
            input.setCursor(cursor);
        }
        boolean tag = false;
        if (input.peek() == '#') {
            input.skip();
            tag = true;
        }
        class_2960 id = class_2960.method_12835((StringReader)input);
        if (!tag) {
            Preconditions.checkArgument((boolean)class_7923.field_41178.method_10250(id), (String)"Unknown item: %s", (Object)id);
        }
        return new ParsedItem(new class_5699.class_7476(id, tag), count);
    }

    @Override
    public String toString() {
        return this.count == 1 ? this.tagOrId.toString() : "%dx %s".formatted(this.count, this.tagOrId);
    }

    private class_1856 rawIngredient() {
        if (this.tagOrId.comp_814()) {
            return class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)this.tagOrId.comp_813()));
        }
        return class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)class_7923.field_41178.method_10223(this.tagOrId.comp_813())});
    }

    public class_1856 ingredient() {
        Preconditions.checkArgument((this.count == 1 ? 1 : 0) != 0, (Object)"Ingredient must not have count");
        return this.rawIngredient();
    }

    public SizedIngredient sizedIngredient() {
        return new SizedIngredient(this.rawIngredient(), this.count);
    }

    public class_1799 itemStack() {
        Preconditions.checkArgument((!this.tagOrId.comp_814() ? 1 : 0) != 0, (Object)"ItemStack must not be a tag");
        return new class_1799((class_1935)class_7923.field_41178.method_17966(this.tagOrId.comp_813()).orElseThrow(), this.count);
    }
}

