/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.context;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Keyable;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_8786;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.recipe.EmptyRecipeInput;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.codec.KeyDispatchedMapMapCodec;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.recipe.ILycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class LycheeContext
extends EmptyRecipeInput {
    public static final Codec<LycheeContext> CODEC = new KeyDispatchedMapMapCodec((Codec<LycheeContextKey>)LycheeRegistries.CONTEXT.method_39673(), it -> {
        Codec serializer = it.codec();
        if (serializer == null) {
            return DataResult.error(() -> String.valueOf(it) + " isn't serializable");
        }
        return DataResult.success(serializer);
    }, (Keyable)LycheeRegistries.CONTEXT_SERIALIZER, () -> new Reference2ReferenceOpenHashMap(LycheeRegistries.CONTEXT.method_10204())).codec().xmap(LycheeContext::new, LycheeContext::serializableContext);
    private final Map<LycheeContextKey<?>, Object> context;
    @Nullable
    private class_1937 level;

    public LycheeContext() {
        this((Map<LycheeContextKey<?>, Object>)new Reference2ReferenceOpenHashMap(LycheeRegistries.CONTEXT.method_10204()));
    }

    public LycheeContext(Map<LycheeContextKey<?>, Object> context) {
        this.context = context;
    }

    public boolean has(LycheeContextKey<?> key, boolean createIfAbsent) {
        if (createIfAbsent && key.factory != null) {
            this.context.computeIfAbsent(key, it -> it.factory.apply(this));
        }
        return this.context.get(key) != null;
    }

    @Nullable
    public <T> T getOrNull(LycheeContextKey.Optional<T> key) {
        return (T)this.context.get(key);
    }

    public <T> T get(LycheeContextKey<T> key) {
        if (key.factory == null) {
            return (T)Objects.requireNonNull(this.context.get(key));
        }
        return (T)Objects.requireNonNull(this.context.computeIfAbsent(key, it -> it.factory.apply(this)));
    }

    @Nullable
    public <T> T put(LycheeContextKey<T> key, T value) {
        if (key == LycheeContextKey.LEVEL) {
            this.level = (class_1937)value;
        }
        return (T)this.context.put(key, value);
    }

    public void put(class_8786<? extends ILycheeRecipe<?>> recipeHolder) {
        this.put(LycheeContextKey.RECIPE, (ILycheeRecipe)recipeHolder.comp_1933());
        this.put(LycheeContextKey.RECIPE_ID, recipeHolder.comp_1932());
    }

    public LootParamsContext initLootParams(LycheeRecipeType<?> recipeType) {
        return this.initLootParams(recipeType.contextParamSet);
    }

    public LootParamsContext initLootParams(class_176 paramSet) {
        LootParamsContext lootParams = new LootParamsContext(this.level(), paramSet);
        this.put(LycheeContextKey.LOOT_PARAMS, lootParams);
        return lootParams;
    }

    public void removeAllExcept(Collection<LycheeContextKey<?>> keys) {
        this.context.keySet().removeIf(key -> !keys.contains(key));
    }

    public Map<LycheeContextKey<?>, Object> serializableContext() {
        return Map.ofEntries((Map.Entry[])this.context.entrySet().stream().filter(entry -> entry.getValue() != null && ((LycheeContextKey)entry.getKey()).codec() != null).toArray(Map.Entry[]::new));
    }

    public class_1937 level() {
        if (this.level == null) {
            this.level = this.get(LycheeContextKey.LEVEL);
        }
        return this.level;
    }

    public int method_59983() {
        return this.get(LycheeContextKey.ITEM).size();
    }

    public class_1799 method_59984(int index) {
        return ((ExtendedItemStackHolder)this.get(LycheeContextKey.ITEM).get(index)).get();
    }

    public void setItem(int index, class_1799 stack) {
        this.get(LycheeContextKey.ITEM).replace(index, stack);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("context", this.context).append("level", (Object)this.level).toString();
    }
}

