/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.context;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_181;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6335;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.AnvilContext;
import snownee.lychee.context.CraftingContext;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.ActionData;
import snownee.lychee.util.action.ActionMarker;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.recipe.ILycheeRecipe;

public abstract sealed class LycheeContextKey<T> {
    public final class_2960 id;
    @Nullable
    public final Function<LycheeContext, T> factory;
    public static final Required<class_1937> LEVEL = LycheeContextKey.req("level");
    public static final Required<class_5819> RANDOM = LycheeContextKey.req("random", it -> it.level().field_9229);
    public static final Required<LootParamsContext> LOOT_PARAMS = LycheeContextKey.req("loot_params", it -> new LootParamsContext(it.level(), LycheeLootContextParamSets.ALL));
    public static final Required<ActionContext> ACTION = LycheeContextKey.req("action", it -> new ActionContext());
    public static final Optional<class_2960> RECIPE_ID = LycheeContextKey.opt("recipe_id");
    public static final Optional<ILycheeRecipe<?>> RECIPE = LycheeContextKey.opt("recipe", it -> {
        class_1860 patt0$temp;
        class_8786<?> holder;
        class_2960 id = it.getOrNull(RECIPE_ID);
        if (id != null && (holder = CommonProxy.recipe(id)) != null && (patt0$temp = holder.comp_1933()) instanceof ILycheeRecipe) {
            ILycheeRecipe lycheeRecipe = (ILycheeRecipe)patt0$temp;
            return lycheeRecipe;
        }
        return null;
    });
    public static final Optional<ItemStackHolderCollection> ITEM = LycheeContextKey.opt("item", it -> ItemStackHolderCollection.empty());
    public static final Optional<ActionMarker> MARKER = LycheeContextKey.opt("marker", it -> {
        class_1937 level = it.level();
        if (level.field_9236) {
            return null;
        }
        class_6335 marker = new class_6335(class_1299.field_33456, level);
        LootParamsContext lootParams = it.get(LOOT_PARAMS);
        class_243 pos = (class_243)lootParams.getOrNull(class_181.field_24424);
        if (pos != null) {
            marker.method_29495(pos);
        }
        marker.method_5665((class_2561)class_2561.method_43470((String)"lychee"));
        level.method_8649((class_1297)marker);
        ActionMarker actionMarker = (ActionMarker)marker;
        actionMarker.lychee$setData(new ActionData((LycheeContext)((Object)it), 0));
        return actionMarker;
    });
    public static final Optional<JsonElement> JSON = LycheeContextKey.opt("data");
    public static final Optional<AnvilContext> ANVIL = LycheeContextKey.opt("anvil");
    public static final Optional<ItemShapelessContext> ITEM_SHAPELESS = LycheeContextKey.opt("item_shapeless");
    public static final Optional<CraftingContext> CRAFTING = LycheeContextKey.opt("crafting");
    public static final Optional<class_2680> DRIPSTONE_SOURCE = LycheeContextKey.opt("dripstone_root");

    protected LycheeContextKey(class_2960 id, @Nullable Function<LycheeContext, T> factory) {
        this.id = id;
        this.factory = factory;
    }

    public String toString() {
        return this.id.toString();
    }

    private static <T extends LycheeContextKey<?>> T register(T object) {
        class_2378.method_10230(LycheeRegistries.CONTEXT, (class_2960)object.id, object);
        return object;
    }

    public static <T> Optional<T> opt(String name) {
        return LycheeContextKey.opt(name, null);
    }

    public static <T> Optional<T> opt(String name, @Nullable Function<LycheeContext, T> factory) {
        return LycheeContextKey.register(new Optional<T>(class_2960.method_60654((String)name), factory));
    }

    public static <T> Required<T> req(String name) {
        return LycheeContextKey.req(name, null);
    }

    public static <T> Required<T> req(String name, @Nullable Function<LycheeContext, T> factory) {
        return LycheeContextKey.register(new Required<T>(class_2960.method_60654((String)name), factory));
    }

    @Nullable
    public Codec<T> codec() {
        class_2960 key = LycheeRegistries.CONTEXT.method_10221((Object)this);
        return (Codec)LycheeRegistries.CONTEXT_SERIALIZER.method_10223(key);
    }

    public static final class Optional<T>
    extends LycheeContextKey<T> {
        public Optional(class_2960 id, @Nullable Function<LycheeContext, T> factory) {
            super(id, factory);
        }
    }

    public static final class Required<T>
    extends LycheeContextKey<T> {
        public Required(class_2960 id, @Nullable Function<LycheeContext, T> factory) {
            super(id, factory);
        }
    }
}

