/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.input;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolder;

public abstract class ItemStackHolderCollection
extends ArrayList<ExtendedItemStackHolder> {
    public final List<class_1799> stacksNeedHandle = Lists.newArrayList();

    public static ItemStackHolderCollection empty() {
        return InWorld.of(new class_1542[0]);
    }

    protected ItemStackHolderCollection(ItemStackHolder ... holders) {
        for (ItemStackHolder holder : holders) {
            this.add(new ExtendedItemStackHolder(holder));
        }
    }

    public ItemStackHolder split(int index, int amount) {
        ExtendedItemStackHolder holder = (ExtendedItemStackHolder)this.get(index);
        class_1799 original = holder.get();
        class_1799 split = holder.split(amount);
        if (!original.method_7960()) {
            this.stacksNeedHandle.add(original);
        }
        holder.set(split);
        return holder;
    }

    public ItemStackHolder replace(int index, class_1799 item) {
        ExtendedItemStackHolder holder = (ExtendedItemStackHolder)this.get(index);
        class_1799 original = holder.replace(item);
        if (!original.method_7960()) {
            this.stacksNeedHandle.add(original);
        }
        this.set(index, holder);
        return holder;
    }

    protected int consumeInputs(int times) {
        int result = 0;
        for (ExtendedItemStackHolder holder : this) {
            if (holder.getConsumption() == 0 || holder.get().method_7960()) continue;
            class_1799 stack = holder.split(times * holder.getConsumption());
            result += stack.method_7947();
        }
        return result;
    }

    public abstract int postApply(boolean var1, int var2);

    public static class InWorld
    extends ItemStackHolderCollection {
        private class_1542 itemEntity;

        public InWorld(ItemStackHolder.Entity ... holders) {
            super(holders);
            if (holders.length > 0) {
                this.itemEntity = holders[0].getEntity();
            }
        }

        public static ItemStackHolderCollection of(class_1542 ... entities) {
            return new InWorld((ItemStackHolder.Entity[])Stream.of(entities).map(ItemStackHolder.Entity::new).toArray(ItemStackHolder.Entity[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            for (class_1799 stack : this.stacksNeedHandle) {
                if (stack.method_7960()) continue;
                class_243 pos = this.itemEntity.method_19538();
                class_1542 newEntity = new class_1542(this.itemEntity.method_37908(), pos.field_1352, pos.field_1351, pos.field_1350, stack);
                this.itemEntity.method_37908().method_8649((class_1297)newEntity);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }

    public static class Inventory
    extends ItemStackHolderCollection {
        private final LycheeContext context;

        public Inventory(LycheeContext context, ItemStackHolder.Direct ... holders) {
            super(holders);
            this.context = context;
        }

        public static ItemStackHolderCollection of(LycheeContext ctx, class_1799 ... items) {
            return new Inventory(ctx, (ItemStackHolder.Direct[])Stream.of(items).map(ItemStackHolder.Direct::new).toArray(ItemStackHolder.Direct[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            LootParamsContext lootParams = this.context.get(LycheeContextKey.LOOT_PARAMS);
            class_1937 level = this.context.level();
            class_1297 entity = (class_1297)lootParams.getOrNull(class_181.field_1226);
            class_1657 player = null;
            if (entity instanceof class_1657) {
                class_1657 playerEntity;
                player = playerEntity = (class_1657)entity;
            }
            class_243 pos = (class_243)lootParams.getOrNull(class_181.field_24424);
            for (class_1799 stack : this.stacksNeedHandle) {
                if (player != null) {
                    if (player.method_7270(stack)) continue;
                    player.method_7328(stack, false);
                    continue;
                }
                if (pos == null) continue;
                CommonProxy.dropItemStack(level, pos.field_1352, pos.field_1351, pos.field_1350, stack, null);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }
}

