/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.json;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;
import snownee.lychee.Lychee;
import snownee.lychee.util.json.JsonFragment;

public class JsonFragmentManager {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLenient().create();
    protected final class_3300 resourceManager;
    protected final class_7654 idConverter;
    protected final JsonFragment.Context context = new JsonFragment.Context(this::getOrLoad, Maps.newHashMap());
    private final Map<class_2960, JsonElement> fragments = Maps.newHashMap();
    private final Set<JsonElement> processed = Sets.newIdentityHashSet();

    public JsonFragmentManager(class_3300 resourceManager) {
        this(resourceManager, "lychee_fragment");
    }

    public JsonFragmentManager(class_3300 resourceManager, String directory) {
        this.resourceManager = resourceManager;
        this.idConverter = class_7654.method_45114((String)directory);
    }

    public void process(JsonElement json) {
        if (this.processed.contains(json)) {
            return;
        }
        try {
            this.processed.add(json);
            this.context.vars().clear();
            JsonFragment.process(json, this.context);
        }
        catch (Exception e) {
            Lychee.LOGGER.error("Failed to process fragment " + String.valueOf(json), (Throwable)e);
        }
    }

    public JsonElement getOrLoad(class_2960 id) {
        return this.fragments.computeIfAbsent(id, k -> {
            try {
                JsonObject fragment = (JsonObject)GSON.fromJson((Reader)this.resourceManager.getResourceOrThrow(this.idConverter.method_45112(id)).method_43039(), JsonObject.class);
                return class_3518.method_15296((JsonObject)fragment, (String)"value");
            }
            catch (Exception e) {
                Lychee.LOGGER.error("Failed to load fragment " + String.valueOf(id), (Throwable)e);
                return null;
            }
        });
    }
}

