/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.particles.dripstone;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.loader.Platform;
import snownee.lychee.Lychee;
import snownee.lychee.RecipeTypes;
import snownee.lychee.mixin.particles.PointedDripstoneBlockAccess;
import snownee.lychee.util.particles.dripstone.DripParticleHandler;

public class DripstoneParticleService {
    public static final Cache<class_2248, DripParticleHandler> particleHandlers = CacheBuilder.newBuilder().build();
    public static final class_2396<class_2388> DRIPSTONE_DRIPPING = FabricParticleTypes.complex(class_2388::method_29128, class_2388::method_56170);
    public static final class_2396<class_2388> DRIPSTONE_FALLING = FabricParticleTypes.complex(class_2388::method_29128, class_2388::method_56170);
    public static final class_2396<class_2388> DRIPSTONE_SPLASH = FabricParticleTypes.complex(class_2388::method_29128, class_2388::method_56170);

    public static boolean spawnDripParticle(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        class_2680 sourceBlock = DripstoneParticleService.findBlockAboveStalactite(level, blockPos, blockState);
        if (sourceBlock == null || !RecipeTypes.DRIPSTONE_DRIPPING.hasSource(sourceBlock.method_26204())) {
            return false;
        }
        class_3610 sourceFluid = sourceBlock.method_26227();
        if (sourceFluid.method_15767(class_3486.field_15518) || sourceFluid.method_15767(class_3486.field_15517)) {
            return false;
        }
        DripParticleHandler handler = DripstoneParticleService.getParticleHandler(level, sourceBlock);
        if (handler == null) {
            return false;
        }
        class_243 vec3 = blockState.method_26226((class_1922)level, blockPos);
        double e = (double)blockPos.method_10263() + 0.5 + vec3.field_1352;
        double f = (double)((float)(blockPos.method_10264() + 1) - 0.6875f) - 0.0625;
        double g = (double)blockPos.method_10260() + 0.5 + vec3.field_1350;
        handler.addParticle(level, blockPos, sourceBlock, e, f, g);
        return true;
    }

    public static DripParticleHandler getParticleHandler(class_1937 level, class_2680 sourceBlock) {
        class_2248 block = sourceBlock.method_26204();
        try {
            return (DripParticleHandler)particleHandlers.get((Object)block, () -> {
                if (!Platform.isPhysicalClient()) {
                    return DripParticleHandler.SIMPLE_DUMMY;
                }
                class_2680 defaultState = block.method_9564();
                int color = defaultState.method_26205((class_1922)level, (class_2338)class_2338.field_10980).field_16011;
                return new DripParticleHandler.Simple(color, defaultState.method_26213() > 4);
            });
        }
        catch (ExecutionException e) {
            Lychee.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static class_2680 findBlockAboveStalactite(class_1937 level, class_2338 pos, class_2680 state) {
        return PointedDripstoneBlockAccess.callFindRootBlock(level, pos, state, 11).map(blockPos -> level.method_8320(blockPos.method_10084())).orElse(null);
    }
}

