/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.predicates;

import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2105;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2404;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.util.ModIdentification;
import snownee.lychee.compat.recipeviewer.RvHelper;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.PropertiesPredicateExtensions;

public class BlockPredicateExtensions {
    public static final class_4550 ANY = new class_4550(Optional.empty(), Optional.empty(), Optional.empty());
    private static final Cache<class_4550, List<class_2680>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Set<class_2769<?>> ITERABLE_PROPERTIES = Sets.newConcurrentHashSet(List.of(class_2741.field_12521, class_2741.field_12556, class_2741.field_12497, class_2741.field_12482, class_2741.field_12550, class_2741.field_27220, class_2741.field_12505, class_2741.field_12511, class_2741.field_12484, class_2741.field_12548, class_2741.field_28716, class_2741.field_12537, class_2741.field_12494, class_2741.field_12541, class_2741.field_12536, class_2741.field_12543, class_2741.field_12538, class_2741.field_20432, class_2741.field_12513, class_2741.field_28063));
    public static final Codec<class_4550> CODEC_FOR_TESTING = BlockPredicateExtensions.codec(true);
    public static final Codec<class_4550> CODEC = BlockPredicateExtensions.codec(false);

    public static DataResult<class_4550> fromString(String s, boolean forTesting) {
        Either result;
        if ("*".equals(s)) {
            return DataResult.success((Object)ANY);
        }
        try {
            result = forTesting ? class_2259.method_41962((class_7225)class_7923.field_41175.method_46771(), (String)s, (boolean)true) : Either.left((Object)class_2259.method_41957((class_7225)class_7923.field_41175.method_46771(), (String)s, (boolean)true));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid block predicate: %s - %s".formatted(s, e.getMessage()));
        }
        return DataResult.success((Object)((class_4550)result.map($ -> new class_4550(Optional.of(class_6885.method_40246((class_6880[])new class_6880[]{$.comp_622().method_41520()})), $.comp_623().isEmpty() ? Optional.empty() : Optional.of(new class_4559($.comp_623().entrySet().stream().map(it -> new class_4559.class_4562(((class_2769)it.getKey()).method_11899(), (class_4559.class_8750)new class_4559.class_4561(BlockPredicateExtensions.getNameByValue((class_2769)it.getKey(), it.getValue())))).toList())), Optional.ofNullable($.comp_624()).map(class_2105::new)), $ -> new class_4550(Optional.of($.comp_625()), $.comp_626().isEmpty() ? Optional.empty() : Optional.of(new class_4559($.comp_626().entrySet().stream().map(it -> new class_4559.class_4562((String)it.getKey(), (class_4559.class_8750)new class_4559.class_4561((String)it.getValue()))).toList())), Optional.ofNullable($.comp_627()).map(class_2105::new)))));
    }

    private static <T extends Comparable<T>> String getNameByValue(class_2769<T> property, Object value) {
        return property.method_11901((Comparable)value);
    }

    private static Codec<class_4550> codec(final boolean forTesting) {
        return Codec.of((Encoder)class_4550.field_45723, (Decoder)new Decoder<class_4550>(){

            public <T> DataResult<Pair<class_4550, T>> decode(DynamicOps<T> ops, T input) {
                DataResult stringValue = ops.getStringValue(input);
                if (stringValue.result().isPresent()) {
                    return BlockPredicateExtensions.fromString((String)stringValue.getOrThrow(), forTesting).flatMap(it -> DataResult.success((Object)Pair.of((Object)it, (Object)ops.empty())));
                }
                DataResult result = class_4550.field_45723.decode(ops, input);
                if (result.result().isPresent() && BlockPredicateExtensions.isAny((class_4550)((Pair)result.getOrThrow()).getFirst())) {
                    if (((MapLike)ops.getMap(input).getOrThrow()).entries().findAny().isPresent()) {
                        return DataResult.error(() -> "Cannot find any valid key in BlockPredicate: " + String.valueOf(input));
                    }
                    return DataResult.error(() -> "Wildcard BlockPredicate must be \"*\" string, but found " + String.valueOf(input));
                }
                return result;
            }
        });
    }

    public static boolean isAny(class_4550 predicate) {
        if (predicate == ANY) {
            return true;
        }
        return predicate.comp_1732().isEmpty() && predicate.comp_1733().isEmpty() && predicate.comp_1734().isEmpty();
    }

    public static Set<class_2248> matchedBlocks(class_4550 predicate) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            return Set.of();
        }
        ArrayList blocks = Lists.newArrayList();
        if (predicate.comp_1732().isPresent()) {
            Iterables.addAll((Collection)blocks, (Iterable)((Iterable)((class_6885)predicate.comp_1732().get()).method_40248().map(arg_0 -> ((class_7922)class_7923.field_41175).method_40260(arg_0), Function.identity())));
        }
        return blocks.stream().map(class_6880::comp_349).collect(Collectors.toSet());
    }

    public static Set<class_3611> matchedFluids(class_4550 predicate) {
        return BlockPredicateExtensions.matchedBlocks(predicate).stream().filter(class_2404.class::isInstance).map(it -> it.method_9564().method_26227()).filter(Predicate.not(class_3610::method_15769)).map(class_3610::method_15772).collect(Collectors.toSet());
    }

    public static List<class_1799> matchedItemStacks(class_4550 predicate) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            return List.of();
        }
        return BlockPredicateExtensions.matchedBlocks(predicate).stream().map(class_2248::method_8389).filter(Predicate.not(class_1802.field_8162::equals)).distinct().map(class_1792::method_7854).toList();
    }

    public static boolean matches(class_4550 predicate, LycheeContext context) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        return BlockPredicateExtensions.unsafeMatches(context.level(), predicate, (class_2680)lootParams.get(class_181.field_1224), () -> (class_2586)lootParams.getOrNull(class_181.field_1228));
    }

    public static boolean unsafeMatches(class_1937 level, class_4550 predicate, class_2680 state, Supplier<class_2586> blockEntitySupplier) {
        if (predicate.comp_1732().isPresent() && !state.method_40143((class_6885)predicate.comp_1732().get())) {
            return false;
        }
        if (predicate.comp_1733().isPresent() && !((class_4559)predicate.comp_1733().get()).method_22514(state)) {
            return false;
        }
        if (predicate.comp_1734().isPresent()) {
            class_2586 blockEntity = blockEntitySupplier.get();
            return blockEntity != null && ((class_2105)predicate.comp_1734().get()).method_9077((class_2520)blockEntity.method_38242((class_7225.class_7874)level.method_30349()));
        }
        return true;
    }

    public static class_2680 anyBlockState(class_4550 predicate) {
        return BlockPredicateExtensions.getShowcaseBlockStates(predicate).stream().findFirst().orElse(class_2246.field_10124.method_9564());
    }

    public static List<class_2680> getShowcaseBlockStates(class_4550 predicate) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            return List.of();
        }
        try {
            return (List)CACHE.get((Object)predicate, () -> BlockPredicateExtensions.getShowcaseBlockStates(predicate, ITERABLE_PROPERTIES));
        }
        catch (ExecutionException e) {
            return List.of();
        }
    }

    public static List<class_2680> getShowcaseBlockStates(class_4550 predicate, Collection<class_2769<?>> iterableProperties) {
        Set<class_2248> blocks = BlockPredicateExtensions.matchedBlocks(predicate);
        if (blocks.isEmpty()) {
            return List.of();
        }
        ArrayList states = Lists.newArrayList();
        for (class_2248 block : blocks) {
            class_2680 state = block.method_9564();
            ArrayListMultimap propertyMap = ArrayListMultimap.create();
            for (class_2769 property : block.method_9595().method_11659()) {
                String name = property.method_11899();
                Optional matcher = predicate.comp_1733().flatMap(it -> PropertiesPredicateExtensions.findMatcher(it, name));
                if (matcher.isPresent()) {
                    for (Comparable object : property.method_11898()) {
                        if (!((class_4559.class_4562)matcher.get()).method_22530(block.method_9595(), (class_2688)((class_2680)state.method_47968(property, object)))) continue;
                        propertyMap.put((Object)property, (Object)object);
                    }
                    continue;
                }
                if (!iterableProperties.contains(property)) continue;
                propertyMap.putAll((Object)property, (Iterable)property.method_11898());
            }
            Stream<Object> stream = Stream.of(state);
            for (Map.Entry e : propertyMap.asMap().entrySet()) {
                stream = stream.flatMap($ -> ((Collection)e.getValue()).stream().map(v -> (class_2680)$.method_47968((class_2769)e.getKey(), v)));
            }
            states.addAll(stream.toList());
        }
        return states;
    }

    public static List<class_2561> getTooltips(class_2680 blockState, class_4550 predicate, RvHelper helper) {
        return BlockPredicateExtensions.getTooltips(blockState, predicate, helper.appendModName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<class_2561> getTooltips(class_2680 blockState, class_4550 predicate, boolean appendModName) {
        if (BlockPredicateExtensions.isAny(predicate)) {
            if (blockState.method_26215()) {
                return List.of(class_2561.method_43471((String)"tip.lychee.anyBlock"));
            }
            return List.of();
        }
        ArrayList list = Lists.newArrayList((Object[])new class_2561[]{blockState.method_26204().method_9518()});
        Optional<List> matchers = predicate.comp_1733().map(class_4559::comp_1830);
        if (matchers.isPresent()) {
            for (class_4559.class_4562 matcher : matchers.get()) {
                class_5250 name = class_2561.method_43470((String)(matcher.comp_1832() + "=")).method_27692(class_124.field_1080);
                class_4559.class_8750 class_87502 = matcher.comp_1833();
                if (class_87502 instanceof class_4559.class_4561) {
                    String value;
                    class_4559.class_4561 class_45612 = (class_4559.class_4561)class_87502;
                    try {
                        var14_15 = class_45612.comp_1831();
                        value = var14_15;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    name.method_10852((class_2561)class_2561.method_43470((String)value).method_27692(class_124.field_1068));
                } else {
                    class_87502 = matcher.comp_1833();
                    if (class_87502 instanceof class_4559.class_4563) {
                        Object maxValue;
                        Object minValue;
                        class_4559.class_4563 class_45632 = (class_4559.class_4563)class_87502;
                        {
                            minValue = var14_15 = class_45632.comp_1834();
                            maxValue = var14_15 = class_45632.comp_1835();
                        }
                        class_2689 definition = blockState.method_26204().method_9595();
                        class_2769 property = definition.method_11663(matcher.comp_1832());
                        if (property == null) continue;
                        com.google.common.base.Supplier rangePair = Suppliers.memoize(() -> {
                            List sorted = property.method_11898().stream().sorted().toList();
                            return Pair.of(sorted.getFirst(), sorted.getLast());
                        });
                        String min = ((Optional)minValue).orElseGet(() -> property.method_11901((Comparable)((Pair)rangePair.get()).getFirst()));
                        String max = ((Optional)maxValue).orElseGet(() -> property.method_11901((Comparable)((Pair)rangePair.get()).getSecond()));
                        name.method_10852((class_2561)class_2561.method_43470((String)min).method_27692(class_124.field_1068));
                        if (!min.equals(max)) {
                            name.method_10852((class_2561)class_2561.method_43470((String)"~").method_27692(class_124.field_1080));
                            name.method_10852((class_2561)class_2561.method_43470((String)max).method_27692(class_124.field_1068));
                        }
                    }
                }
                list.add(name);
            }
        }
        if (predicate.comp_1734().isPresent()) {
            list.add(class_2561.method_43471((String)"tip.lychee.nbtPredicate").method_27692(class_124.field_1080));
        }
        if (appendModName && ClientProxy.hasJade) {
            list.add(IThemeHelper.get().modName((Object)ModIdentification.getModName((class_2248)blockState.method_26204())));
        }
        return list;
    }
}

