/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_8786;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.contextual.Chance;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ChanceRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class BlockKeyableRecipeType<R extends BlockKeyableRecipe>
extends LycheeRecipeType<R> {
    protected final Map<class_2248, List<class_8786<R>>> recipesByBlock = Maps.newHashMap();
    protected final List<class_8786<R>> anyBlockRecipes = Lists.newLinkedList();
    public boolean extractChance;

    public BlockKeyableRecipeType(String name, Class<R> clazz, @Nullable class_176 paramSet) {
        super(name, clazz, paramSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        this.recipesByBlock.clear();
        this.anyBlockRecipes.clear();
        super.refreshCache();
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (class_8786 class_87862 : this.recipes) {
            ContextualCondition condition;
            Iterator<ContextualCondition> iterator = ((BlockKeyableRecipe)class_87862.comp_1933()).conditions().iterator();
            if (iterator.hasNext() && (condition = iterator.next()) instanceof Chance) {
                float chance2;
                Chance chance = (Chance)condition;
                try {
                    float f;
                    chance2 = f = chance.chance();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                class_1860 class_18602 = class_87862.comp_1933();
                if (class_18602 instanceof ChanceRecipe) {
                    ChanceRecipe chanceRecipe = (ChanceRecipe)class_18602;
                    chanceRecipe.setChance(chance2);
                }
            }
            if (BlockPredicateExtensions.isAny(((BlockKeyableRecipe)class_87862.comp_1933()).blockPredicate())) {
                this.anyBlockRecipes.add(class_87862);
                continue;
            }
            for (class_2248 block : BlockPredicateExtensions.matchedBlocks(((BlockKeyableRecipe)class_87862.comp_1933()).blockPredicate())) {
                multimap.put((Object)block, (Object)class_87862);
            }
        }
        Iterator<Object> iterator = multimap.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.recipesByBlock.put((class_2248)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return;
    }

    @Override
    public Comparator<class_8786<R>> comparator() {
        return Comparator.comparing(class_8786::comp_1933, Comparator.comparing($ -> !BlockPredicateExtensions.isAny($.blockPredicate())).thenComparingInt($ -> $.method_8117().size()).thenComparing($ -> !$.maxRepeats().method_9041()).thenComparing(class_1860::method_8118).reversed());
    }

    public List<class_1799> blockKeysToItems() {
        return this.recipesByBlock.keySet().stream().map(class_2248::method_8389).filter($ -> $ != class_1802.field_8162).sorted(Comparator.comparingInt(class_1792::method_7880)).map(class_1792::method_7854).toList();
    }

    public Optional<R> process(class_1657 player, class_1268 hand, class_2338 pos, class_243 origin, LycheeContext context) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        class_1937 level = player.method_37908();
        class_2680 blockstate = level.method_8320(pos);
        List<class_8786<R>> recipes = this.recipesByBlock.getOrDefault(blockstate.method_26204(), List.of());
        if (recipes.isEmpty() && this.anyBlockRecipes.isEmpty()) {
            return Optional.empty();
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        lootParams.set(class_181.field_24424, CommonProxy.clampPos(origin, pos));
        lootParams.set(class_181.field_1226, player);
        lootParams.set(class_181.field_1224, blockstate);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, pos);
        lootParams.validate();
        class_1799 stack = player.method_5998(hand);
        class_1799 otherStack = player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
        context.put(LycheeContextKey.ITEM, ItemStackHolderCollection.Inventory.of(context, stack, otherStack));
        ItemStackHolderCollection itemContext = context.get(LycheeContextKey.ITEM);
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        Iterable<class_8786<R>> iterable = this.mergeAnyBlockRecipes(recipes);
        for (class_8786<R> recipeHolder : iterable) {
            if (!this.tryMatch(recipeHolder, level, context).isPresent()) continue;
            context.put(recipeHolder);
            BlockKeyableRecipe recipe = (BlockKeyableRecipe)recipeHolder.comp_1933();
            if (!level.field_9236 && recipe.tickOrApply(context)) {
                int times;
                if (recipe.sizedIngredients().size() == 1) {
                    ((ExtendedItemStackHolder)itemContext.get(1)).setConsumption(0);
                }
                for (int i = 0; i < recipe.sizedIngredients().size(); ++i) {
                    ((ExtendedItemStackHolder)itemContext.get(i)).setConsumption(recipe.sizedIngredients().get(i).count());
                }
                if (recipe.maxRepeats() == BoundsExtensions.ONE) {
                    times = 1;
                } else {
                    times = Integer.MAX_VALUE;
                    for (ExtendedItemStackHolder holder : itemContext) {
                        if (holder.getConsumption() == 0) continue;
                        int count = holder.get().method_7947() / holder.getConsumption();
                        if (count == 0) {
                            return Optional.empty();
                        }
                        times = Math.min(times, count);
                    }
                }
                times = recipe.getRandomRepeats(Math.max(1, times), context);
                recipe.applyPostActions(context, times);
                itemContext.postApply(!actionContext.avoidDefault, times);
                player.method_6122(hand, context.method_59984(0));
                player.method_6122(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808, context.method_59984(1));
            }
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public boolean has(class_2248 block) {
        return !this.anyBlockRecipes.isEmpty() || this.recipesByBlock.containsKey(block);
    }

    public boolean has(class_2680 state) {
        return this.has(state.method_26204());
    }

    @Nullable
    public class_8786<R> process(class_1937 level, class_2680 state, LycheeContext context) {
        List<class_8786<R>> recipes = this.recipesByBlock.getOrDefault(state.method_26204(), List.of());
        Iterable<class_8786<R>> iterable = this.mergeAnyBlockRecipes(recipes);
        for (class_8786<R> recipe : iterable) {
            ChanceRecipe chance;
            if (this.extractChance && (chance = (ChanceRecipe)recipe.comp_1933()).getChance() != 1.0f && chance.getChance() <= context.get(LycheeContextKey.RANDOM).method_43057() || !this.tryMatch(recipe, level, context).isPresent()) continue;
            context.put(recipe);
            ((BlockKeyableRecipe)recipe.comp_1933()).applyPostActions(context, 1);
            return recipe;
        }
        return null;
    }

    public Iterable<class_8786<R>> mergeAnyBlockRecipes(List<class_8786<R>> recipes) {
        if (this.anyBlockRecipes.isEmpty()) {
            return recipes;
        }
        if (recipes.isEmpty()) {
            return this.anyBlockRecipes;
        }
        return Iterables.concat(recipes, this.anyBlockRecipes);
    }
}

