/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_4550;
import net.minecraft.class_7225;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.recipe.SizedIngredient;
import snownee.lychee.context.ActionContext;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.NonNullListExtensions;
import snownee.lychee.util.Reference;
import snownee.lychee.util.action.Job;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionDisplay;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.Contextual;
import snownee.lychee.util.contextual.ContextualHolder;
import snownee.lychee.util.contextual.ContextualPredicate;
import snownee.lychee.util.json.JsonPointer;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;

public interface ILycheeRecipe<C extends class_9695>
extends class_1860<C>,
ContextualPredicate,
Contextual {
    public static final String DEFAULT_GROUP = "default";
    public static final String ITEM_IN = "item_in";
    public static final String ITEM_OUT = "item_out";
    public static final String BLOCK_IN = "block_in";
    public static final JsonPointer ITEM_IN_POINTER = new JsonPointer("/item_in");
    public static final JsonPointer ITEM_OUT_POINTER = new JsonPointer("/item_out");
    public static final JsonPointer RESULT_POINTER = new JsonPointer("/result");
    public static final JsonPointer POST_POINTER = new JsonPointer("/post");

    default public void onConstructed() {
        this.allActions().forEach(it -> it.validate(this));
    }

    default public IntList getItemIndexes(Reference reference) {
        JsonPointer pointer = null;
        if (reference == Reference.DEFAULT) {
            pointer = this.defaultItemPointer();
        } else if (reference.isPointer()) {
            pointer = reference.getPointer();
        }
        if (pointer != null) {
            return this.getItemIndexes(pointer);
        }
        return IntList.of();
    }

    default public IntList getItemIndexes(JsonPointer pointer) {
        int size;
        try {
            size = this.sizedIngredients().size();
        }
        catch (Exception ignored) {
            size = this.method_8117().size();
        }
        if (pointer.size() == 1 && pointer.getString(0).equals(ITEM_IN)) {
            return IntList.of((int[])IntStream.range(0, size).toArray());
        }
        if (pointer.size() == 2 && pointer.getString(0).equals(ITEM_IN)) {
            try {
                return IntList.of((int)pointer.getInt(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IntList.of();
    }

    default public class_1799 method_8116(C inv, class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    default public JsonPointer defaultItemPointer() {
        return ITEM_IN_POINTER;
    }

    default public boolean tickOrApply(LycheeContext context) {
        return true;
    }

    public boolean method_8115(C var1, class_1937 var2);

    default public boolean method_8113(int width, int height) {
        return true;
    }

    default public class_1799 method_8110(class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    public class_3956<? extends class_1860<?>> method_17716();

    public LycheeRecipeCommonProperties commonProperties();

    @Override
    default public ContextualHolder conditions() {
        return this.commonProperties().conditions();
    }

    @Override
    default public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.conditions().test(recipe, ctx, times);
    }

    default public boolean hideInRecipeViewer() {
        return this.commonProperties().hideInRecipeViewer();
    }

    default public boolean ghost() {
        return this.commonProperties().ghost();
    }

    default public Optional<String> comment() {
        return this.commonProperties().comment();
    }

    default public String group() {
        return this.commonProperties().group();
    }

    default public List<PostAction> postActions() {
        return this.commonProperties().postActions();
    }

    default public class_2096.class_2100 maxRepeats() {
        return this.commonProperties().maxRepeats();
    }

    default public int getRandomRepeats(int max, LycheeContext ctx) {
        if (this.maxRepeats() == BoundsExtensions.ONE) {
            return 1;
        }
        int times = Integer.MAX_VALUE;
        if (!this.maxRepeats().method_9041()) {
            times = BoundsExtensions.random(this.maxRepeats(), ctx.get(LycheeContextKey.RANDOM));
        }
        return class_3532.method_15340((int)times, (int)1, (int)max);
    }

    default public Stream<PostAction> allActions() {
        return this.postActions().stream();
    }

    default public void applyPostActions(LycheeContext context, int times) {
        if (!context.level().field_9236) {
            ActionContext actionContext = context.get(LycheeContextKey.ACTION);
            actionContext.reset();
            actionContext.jobs.addAll(this.postActions().stream().map(it -> new Job((PostAction)it, times)).toList());
            actionContext.run(context);
        }
    }

    default public List<class_4550> getBlockInputs() {
        BlockKeyableRecipe blockPredicateRecipe;
        ILycheeRecipe iLycheeRecipe = this;
        if (iLycheeRecipe instanceof BlockKeyableRecipe && !BlockPredicateExtensions.isAny((blockPredicateRecipe = (BlockKeyableRecipe)iLycheeRecipe).blockPredicate())) {
            return List.of(blockPredicateRecipe.blockPredicate());
        }
        return List.of();
    }

    default public List<class_4550> getBlockOutputs() {
        return this.allActions().filter(it -> !it.hidden()).map(PostActionDisplay::getOutputBlocks).flatMap(Collection::stream).toList();
    }

    @Nullable
    default public IngredientCollection ingredientCollection() {
        return null;
    }

    default public List<SizedIngredient> sizedIngredients() {
        IngredientCollection collection = this.ingredientCollection();
        if (collection == null) {
            throw new UnsupportedOperationException();
        }
        return collection.ingredients();
    }

    default public class_2371<class_1856> method_8117() {
        IngredientCollection collection = this.ingredientCollection();
        if (collection == null) {
            return NonNullListExtensions.copyOf(List.of());
        }
        return collection.flattenedIngredients();
    }
}

