/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.codec.AliasOptionalFieldCodec;
import snownee.lychee.util.codec.LycheeStreamCodecs;
import snownee.lychee.util.contextual.ContextualHolder;

public record LycheeRecipeCommonProperties(boolean hideInRecipeViewer, boolean ghost, Optional<String> comment, String group, ContextualHolder conditions, List<PostAction> postActions, class_2096.class_2100 maxRepeats) {
    public static final MapCodec<Boolean> HIDE_IN_VIEWER_CODEC = Codec.BOOL.optionalFieldOf("hide_in_viewer", (Object)false);
    public static final MapCodec<Boolean> GHOST_CODEC = Codec.BOOL.optionalFieldOf("ghost", (Object)false);
    public static final MapCodec<Optional<String>> COMMENT_CODEC = Codec.STRING.optionalFieldOf("comment");
    public static final MapCodec<String> GROUP_CODEC = Codec.STRING.validate(s -> {
        if (class_2960.method_12829((String)s) == null) {
            return DataResult.error(() -> "Invalid group: " + s + " (must be a valid resource location)");
        }
        return DataResult.success((Object)s);
    }).optionalFieldOf("group", (Object)"default");
    public static final MapCodec<ContextualHolder> CONTEXTUAL_CODEC = AliasOptionalFieldCodec.defaulted("if", ContextualHolder.CODEC, ContextualHolder.EMPTY, "contextual");
    public static final MapCodec<List<PostAction>> POST_ACTION_CODEC = PostAction.LIST_CODEC.optionalFieldOf("post", List.of());
    public static final MapCodec<LycheeRecipeCommonProperties> SIMPLE_MAP_CODEC = LycheeRecipeCommonProperties.mapCodec(class_2096.class_2100.field_9708);
    public static final class_9139<class_9129, LycheeRecipeCommonProperties> STREAM_CODEC = LycheeStreamCodecs.composite(class_9135.field_48547, LycheeRecipeCommonProperties::hideInRecipeViewer, class_9135.field_48547, LycheeRecipeCommonProperties::ghost, class_9135.method_56382((class_9139)class_9135.field_48554), LycheeRecipeCommonProperties::comment, class_9135.field_48554, LycheeRecipeCommonProperties::group, ContextualHolder.STREAM_CODEC, LycheeRecipeCommonProperties::conditions, PostAction.STREAM_LIST_CODEC, LycheeRecipeCommonProperties::postActions, class_9135.method_56368((Codec)class_2096.class_2100.field_45763), LycheeRecipeCommonProperties::maxRepeats, LycheeRecipeCommonProperties::new);

    public static MapCodec<LycheeRecipeCommonProperties> mapCodec(class_2096.class_2100 defaultMaxRepeats) {
        return RecordCodecBuilder.mapCodec((T instance) -> instance.group((App)HIDE_IN_VIEWER_CODEC.forGetter(LycheeRecipeCommonProperties::hideInRecipeViewer), (App)GHOST_CODEC.forGetter(LycheeRecipeCommonProperties::ghost), (App)COMMENT_CODEC.forGetter(LycheeRecipeCommonProperties::comment), (App)GROUP_CODEC.forGetter(LycheeRecipeCommonProperties::group), (App)CONTEXTUAL_CODEC.forGetter(LycheeRecipeCommonProperties::conditions), (App)POST_ACTION_CODEC.forGetter(LycheeRecipeCommonProperties::postActions), (App)class_2096.class_2100.field_45763.optionalFieldOf("max_repeats", (Object)defaultMaxRepeats).forGetter(LycheeRecipeCommonProperties::maxRepeats)).apply((Applicative)instance, LycheeRecipeCommonProperties::of));
    }

    private static LycheeRecipeCommonProperties of(boolean hideInRecipeViewer, boolean ghost, Optional<String> comment, String group, ContextualHolder conditions, List<PostAction> postActions, class_2096.class_2100 maxRepeats) {
        if (postActions.stream().anyMatch(it -> !it.repeatable())) {
            maxRepeats = BoundsExtensions.ONE;
        }
        return new LycheeRecipeCommonProperties(hideInRecipeViewer, ghost, comment, group, conditions, postActions, maxRepeats);
    }
}

